package eu.dnetlib.msro.workflows.nodes.stats;

import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import eu.dnetlib.enabling.tools.blackboard.BlackboardJob;
import eu.dnetlib.msro.workflows.procs.Token;

/**
 * Ask the StatsManagerService to backup the stats cache of the portal specified by the additional BB parameter
 * <code>StatsManagerServiceBBAction.BACKUP_CACHE.getTargetPortalParamName()</code>. The cache can be restored with the last generated
 * backup by sending a "restore" BB message.
 *
 * @see RestoreStatsCacheJobNode
 * @author alessia
 *
 */
public class BackupStatsCacheJobNode extends AbstractStatsJobNode {

	private static final Log log = LogFactory.getLog(BackupStatsCacheJobNode.class); // NOPMD by marko on 11/24/08 5:02 PM

	@Override
	protected void prepareJob(final BlackboardJob job, final Token token) throws Exception {
		job.setAction(StatsManagerServiceBBAction.BACKUP_CACHE.action());
		final String portal = getPortalName(token.getEnv());
		if (StringUtils.isNotBlank(portal)) {
			job.getParameters().put(StatsManagerServiceBBAction.BACKUP_CACHE.getTargetPortalParamName(), portal);
		} else {
			log.warn(StatsManagerServiceBBAction.BACKUP_CACHE.getTargetPortalParamName() + " not set. The StatsManagerService will use its default.");
		}
	}
}
