/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.msro.workflows.nodes;

import com.google.gson.Gson;
import eu.dnetlib.enabling.locators.UniqueServiceLocator;
import eu.dnetlib.msro.workflows.graph.Arc;
import eu.dnetlib.msro.workflows.nodes.SimpleJobNode;
import eu.dnetlib.msro.workflows.procs.Env;
import eu.dnetlib.rmi.enabling.ISLookUpException;
import eu.dnetlib.rmi.enabling.ISLookUpService;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FetchRelClassesJobNode
extends SimpleJobNode {
    private static final Log log = LogFactory.getLog(FetchRelClassesJobNode.class);
    private String xquery;
    private String relClassesName;
    @Resource
    private UniqueServiceLocator serviceLocator;

    protected String execute(Env env) throws Exception {
        String relClasses = new Gson().toJson(this.fetchRelClasses());
        log.info((Object)("loaded relClasses: " + relClasses));
        env.setAttribute(this.getRelClassesName(), (Object)relClasses);
        return Arc.DEFAULT_ARC;
    }

    private List<String> fetchRelClasses() throws ISLookUpException {
        log.info((Object)("Loading relClasses with xquery: " + this.getXquery()));
        return ((ISLookUpService)this.serviceLocator.getService(ISLookUpService.class)).quickSearchProfile(this.getXquery());
    }

    public String getRelClassesName() {
        return this.relClassesName;
    }

    public void setRelClassesName(String relClassesName) {
        this.relClassesName = relClassesName;
    }

    public String getXquery() {
        return this.xquery;
    }

    public void setXquery(String xquery) {
        this.xquery = xquery;
    }
}

