/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.msro.workflows.nodes;

import eu.dnetlib.enabling.locators.UniqueServiceLocator;
import eu.dnetlib.msro.workflows.graph.Arc;
import eu.dnetlib.msro.workflows.nodes.SimpleJobNode;
import eu.dnetlib.msro.workflows.procs.Env;
import eu.dnetlib.rmi.enabling.ISRegistryException;
import eu.dnetlib.rmi.enabling.ISRegistryService;
import javax.annotation.Resource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class IndexDSUpdateJobNode
extends SimpleJobNode {
    private static final Log log = LogFactory.getLog(IndexDSUpdateJobNode.class);
    public static final String N_RECORDS_PARAM = "blackboard:param:index.status code: 0";
    @Resource
    private UniqueServiceLocator serviceLocator;

    public String execute(Env env) throws Exception {
        String dsId = (String)env.getAttribute("index_id", String.class);
        String version = (String)env.getAttribute("index.feed.timestamp", String.class);
        try {
            int count = Integer.parseInt((String)env.getAttribute(N_RECORDS_PARAM, String.class));
            log.info((Object)("updating indexDS: " + dsId + " version: " + version + " record count: " + count));
            this.updateIndexDS(dsId, version, count);
        }
        catch (NumberFormatException e) {
            log.warn((Object)"unable to find index feeding details in the workflow env, skippind DS update");
        }
        return Arc.DEFAULT_ARC;
    }

    private boolean updateIndexDS(String dsId, String version, long count) throws ISRegistryException {
        String xquery = "for $x in collection('')/RESOURCE_PROFILE[.//RESOURCE_IDENTIFIER/@value = '" + dsId + "'] return update value $x//INDEX_SIZE with " + String.valueOf(count) + ",for $x in collection('')/RESOURCE_PROFILE[.//RESOURCE_IDENTIFIER/@value = '" + dsId + "'] return update value $x//INDEX_LAST_UPDATE with '" + version + "' ";
        log.debug((Object)("\n\n updating indexDataStructure: " + xquery + "\n\n"));
        return ((ISRegistryService)this.serviceLocator.getService(ISRegistryService.class)).executeXUpdate(xquery);
    }
}

