/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.msro.workflows.nodes.actionmanager;

import com.google.common.base.Predicate;
import com.google.common.collect.Maps;
import com.google.gson.Gson;
import eu.dnetlib.enabling.locators.UniqueServiceLocator;
import eu.dnetlib.miscutils.datetime.DateUtils;
import eu.dnetlib.msro.workflows.graph.Arc;
import eu.dnetlib.msro.workflows.nodes.SimpleJobNode;
import eu.dnetlib.msro.workflows.procs.Env;
import eu.dnetlib.rmi.data.hadoop.actionmanager.RawSet;
import eu.dnetlib.rmi.enabling.ISLookUpService;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class PrepareActionSetsJobNode
extends SimpleJobNode {
    private static final Log log = LogFactory.getLog(PrepareActionSetsJobNode.class);
    @Autowired
    private UniqueServiceLocator serviceLocator;
    private String sets;

    protected String execute(Env env) throws Exception {
        List<Map<String, String>> setList = this.getSetList();
        String now = DateUtils.now_ISO8601();
        String basePath = ((ISLookUpService)this.serviceLocator.getService(ISLookUpService.class)).getResourceProfileByQuery("/RESOURCE_PROFILE[./HEADER/RESOURCE_TYPE/@value='ActionManagerServiceResourceType']//SERVICE_PROPERTIES/PROPERTY[@key='basePath']/@value/string()");
        for (Map<String, String> set : setList) {
            set.put("rawset", RawSet.newInstance().getId());
            set.put("creationDate", now);
            set.put("path", this.getPath(basePath, set));
            if (set.get("enabled").equals("true")) {
                log.info((Object)("preparing set: " + this.simplifySetInfo(set)));
            }
            env.setAttribute(set.get("jobProperty"), (Object)set.get("rawset"));
        }
        env.setAttribute("sets", (Object)new Gson().toJson(setList));
        env.setAttribute("actionManagerBasePath", (Object)basePath);
        return Arc.DEFAULT_ARC;
    }

    private String getPath(String basePath, Map<String, String> set) {
        StringBuilder sb = new StringBuilder();
        sb.append(basePath).append("/").append(set.get("set")).append("/").append(set.get("rawset"));
        String path = sb.toString();
        log.debug((Object)("path: " + path));
        return path;
    }

    private Map<String, String> simplifySetInfo(Map<String, String> set) {
        return Maps.filterKeys(set, (Predicate)new Predicate<String>(){

            public boolean apply(String k) {
                return k.equals("set") || k.equals("rawset");
            }
        });
    }

    protected List<Map<String, String>> getSetList() {
        return (List)new Gson().fromJson(this.getSets(), List.class);
    }

    public String getSets() {
        return this.sets;
    }

    public void setSets(String sets) {
        this.sets = sets;
    }
}

