/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.msro.workflows.nodes.datacite;

import eu.dnetlib.enabling.resultset.client.ResultSetClient;
import eu.dnetlib.enabling.resultset.factory.ResultSetFactory;
import eu.dnetlib.msro.workflows.graph.Arc;
import eu.dnetlib.msro.workflows.nodes.SimpleJobNode;
import eu.dnetlib.msro.workflows.nodes.datacite.IteratorOnQueue;
import eu.dnetlib.msro.workflows.nodes.datacite.SplitterDatasetsIterator;
import eu.dnetlib.msro.workflows.procs.Env;
import eu.dnetlib.rmi.common.ResultSet;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import org.springframework.beans.factory.annotation.Autowired;

public class SplitDatasetRecord
extends SimpleJobNode {
    private String inputEprParm;
    private String outputEprParm;
    @Autowired
    private ResultSetClient resultSetClient;
    @Autowired
    private ResultSetFactory resultSetFactory;
    private final Executor executor = Executors.newSingleThreadExecutor();

    protected String execute(Env env) throws Exception {
        ResultSet inputEpr = (ResultSet)env.getAttribute(this.inputEprParm, ResultSet.class);
        Iterable input = this.resultSetClient.iter(inputEpr, String.class);
        LinkedBlockingQueue<String> publicationsQueue = new LinkedBlockingQueue<String>();
        final SplitterDatasetsIterator splitterIterator = new SplitterDatasetsIterator(publicationsQueue, input, "publications");
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                splitterIterator.populateQueues();
            }
        });
        ResultSet eprUrls_publications = this.resultSetFactory.createResultSet(() -> new IteratorOnQueue<String>(publicationsQueue, SplitterDatasetsIterator.END_QUEUE));
        env.setAttribute(this.getOutputEprParm(), (Object)eprUrls_publications);
        return Arc.DEFAULT_ARC;
    }

    public String getInputEprParm() {
        return this.inputEprParm;
    }

    public void setInputEprParm(String inputEprParm) {
        this.inputEprParm = inputEprParm;
    }

    public String getOutputEprParm() {
        return this.outputEprParm;
    }

    public void setOutputEprParm(String outputEprParm) {
        this.outputEprParm = outputEprParm;
    }
}

