/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.msro.workflows.nodes.dedup;

import eu.dnetlib.enabling.tools.blackboard.BlackboardJob;
import eu.dnetlib.msro.workflows.nodes.dedup.utils.DedupConfigurationOrchestration;
import eu.dnetlib.msro.workflows.nodes.dedup.utils.DedupConfigurationOrchestrationLoader;
import eu.dnetlib.msro.workflows.nodes.hadoop.SubmitHadoopJobNode;
import eu.dnetlib.msro.workflows.procs.Token;
import eu.dnetlib.pace.config.DedupConfig;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class DedupConfigurationLoaderJobNode
extends SubmitHadoopJobNode {
    private static final Log log = LogFactory.getLog(DedupConfigurationLoaderJobNode.class);
    private String dedupConfigSequence;
    @Autowired
    private DedupConfigurationOrchestrationLoader dedupOrchestrationLoader;

    @Override
    protected void prepareJob(BlackboardJob job, Token token) throws Exception {
        super.prepareJob(job, token);
        DedupConfigurationOrchestration dedupOrchestration = this.dedupOrchestrationLoader.loadByActionSetId(this.getDedupConfigSequence());
        DedupConfig currentConf = dedupOrchestration.getConfigurations().peek();
        log.debug((Object)("using dedup configuration: '" + currentConf + "'"));
        job.getParameters().put("dedup.conf", currentConf.toString());
    }

    public String getDedupConfigSequence() {
        return this.dedupConfigSequence;
    }

    public void setDedupConfigSequence(String dedupConfigSequence) {
        this.dedupConfigSequence = dedupConfigSequence;
    }
}

