/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.msro.workflows.nodes.dedup;

import eu.dnetlib.enabling.locators.UniqueServiceLocator;
import eu.dnetlib.miscutils.datetime.DateUtils;
import eu.dnetlib.msro.workflows.graph.Arc;
import eu.dnetlib.msro.workflows.nodes.SimpleJobNode;
import eu.dnetlib.msro.workflows.procs.Env;
import eu.dnetlib.rmi.enabling.ISLookUpException;
import eu.dnetlib.rmi.enabling.ISLookUpService;
import eu.dnetlib.rmi.manager.MSROException;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PrepareDedupIndexJobNode
extends SimpleJobNode {
    private static final Log log = LogFactory.getLog(PrepareDedupIndexJobNode.class);
    public static final String SEPARATOR = "_";
    private String mdFormat;
    private String layout;
    private String interpretation;
    private String rottenRecordsPathParam;
    private String hbaseTable;
    @Resource
    private UniqueServiceLocator serviceLocator;

    protected String execute(Env env) throws Exception {
        log.info((Object)"start preparing job");
        String fields = this.getFields(this.getMdFormat(), this.getLayout());
        env.setAttribute("index.fields", (Object)fields);
        if (StringUtils.isBlank((CharSequence)this.getRottenRecordsPathParam())) {
            throw new MSROException("missing rotten records path param");
        }
        env.setAttribute(this.getRottenRecordsPathParam(), (Object)("/tmp" + this.getFileName("rottenrecords")));
        env.setAttribute("index.solr.url", (Object)this.getIndexSolrUrlZk());
        env.setAttribute("index.solr.collection", (Object)this.getCollectionName());
        env.setAttribute("index.shutdown.wait.time", (Object)this.getIndexSolrShutdownWait());
        env.setAttribute("index.buffer.flush.threshold", (Object)this.getIndexBufferFlushTreshold());
        env.setAttribute("index.solr.sim.mode", (Object)this.isFeedingSimulationMode());
        env.setAttribute("index.feed.timestamp", (Object)DateUtils.now_ISO8601());
        env.setAttribute("entityType", env.getAttribute("entityType"));
        env.setAttribute("entityTypeId", env.getAttribute("entityTypeId"));
        return Arc.DEFAULT_ARC;
    }

    private String getFields(String format, String layout) throws ISLookUpException {
        return this.isLookup(String.format("<FIELDS>{for $x in collection('')//RESOURCE_PROFILE[.//RESOURCE_TYPE/@value = 'MDFormatDSResourceType' and .//NAME='%s']//LAYOUT[@name='%s']/FIELDS/FIELD return $x[string(@path)]}</FIELDS>", format, layout));
    }

    public String getIndexSolrUrlZk() throws ISLookUpException {
        return this.isLookup("for $x in /RESOURCE_PROFILE[.//RESOURCE_TYPE/@value='IndexServiceResourceType'] return $x//PROTOCOL[./@name='solr']/@address/string()");
    }

    public String getIndexSolrShutdownWait() throws ISLookUpException {
        return this.queryForServiceProperty("solr:feedingShutdownTolerance");
    }

    public String getIndexBufferFlushTreshold() throws ISLookUpException {
        return this.queryForServiceProperty("solr:feedingBufferFlushThreshold");
    }

    public String isFeedingSimulationMode() throws ISLookUpException {
        return this.queryForServiceProperty("solr:feedingSimulationMode");
    }

    private String queryForServiceProperty(String key) throws ISLookUpException {
        return this.isLookup("for $x in /RESOURCE_PROFILE[.//RESOURCE_TYPE/@value='IndexServiceResourceType'] return $x//SERVICE_PROPERTIES/PROPERTY[./@ key='" + key + "']/@value/string()");
    }

    private String isLookup(String xquery) throws ISLookUpException {
        log.debug((Object)("quering for service property: " + xquery));
        String res = ((ISLookUpService)this.serviceLocator.getService(ISLookUpService.class)).getResourceProfileByQuery(xquery);
        if (StringUtils.isBlank((CharSequence)res)) {
            throw new IllegalStateException("unable to find unique service property, xquery: " + xquery);
        }
        return res;
    }

    private String getFileName(String fileNamePrefix) {
        return "/" + fileNamePrefix + SEPARATOR + this.getHbaseTable() + SEPARATOR + this.getMdFormat() + ".seq";
    }

    private String getCollectionName() {
        return this.getMdFormat() + SEPARATOR + this.getLayout() + SEPARATOR + this.getInterpretation();
    }

    public String getHbaseTable() {
        return this.hbaseTable;
    }

    public void setHbaseTable(String hbaseTable) {
        this.hbaseTable = hbaseTable;
    }

    public String getRottenRecordsPathParam() {
        return this.rottenRecordsPathParam;
    }

    public void setRottenRecordsPathParam(String rottenRecordsPathParam) {
        this.rottenRecordsPathParam = rottenRecordsPathParam;
    }

    public String getMdFormat() {
        return this.mdFormat;
    }

    public void setMdFormat(String mdFormat) {
        this.mdFormat = mdFormat;
    }

    public String getLayout() {
        return this.layout;
    }

    public void setLayout(String layout) {
        this.layout = layout;
    }

    public String getInterpretation() {
        return this.interpretation;
    }

    public void setInterpretation(String interpretation) {
        this.interpretation = interpretation;
    }
}

