/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.msro.workflows.nodes.hadoop;

import eu.dnetlib.msro.workflows.graph.Arc;
import eu.dnetlib.msro.workflows.nodes.SimpleJobNode;
import eu.dnetlib.msro.workflows.procs.Env;
import eu.dnetlib.rmi.manager.MSROException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CheckHDFSCountJobNode
extends SimpleJobNode {
    private static final Log log = LogFactory.getLog(CheckHDFSCountJobNode.class);
    private String numberToVerifyParamName;
    private String hdfsCounterParamName = "mainlog:storeHdfsRecords:count";

    public String execute(Env env) throws MSROException {
        int hdfsCount = 0;
        int hbaseCount = 0;
        String numberToVerifyInEnvParam = "blackboard:param:" + this.numberToVerifyParamName;
        hbaseCount = this.getValueFromEnv(env, numberToVerifyInEnvParam);
        hdfsCount = this.getValueFromEnv(env, this.hdfsCounterParamName);
        if (hdfsCount != hbaseCount) {
            log.warn((Object)("Numbers are not the same. Number to verify (hbase count): " + hbaseCount + ". From hdfs: " + hdfsCount));
            log.warn((Object)(hdfsCount - hbaseCount + " records come without a 'metadata' field"));
            env.setAttribute("noMetadataRecords", (Object)(hdfsCount - hbaseCount));
        }
        return Arc.DEFAULT_ARC;
    }

    private int getValueFromEnv(Env env, String paramName) throws MSROException {
        String valueString = (String)env.getAttribute(paramName, String.class);
        int number = 0;
        try {
            number = Integer.parseInt(valueString);
        }
        catch (NumberFormatException e) {
            log.error((Object)("Env param name: " + paramName + " is " + valueString + " and cannot be parsed as integer"));
            throw new MSROException((Throwable)e);
        }
        return number;
    }

    public String getNumberToVerifyParamName() {
        return this.numberToVerifyParamName;
    }

    public void setNumberToVerifyParamName(String numberToVerifyParamName) {
        this.numberToVerifyParamName = numberToVerifyParamName;
    }

    public String getHdfsCounterParamName() {
        return this.hdfsCounterParamName;
    }

    public void setHdfsCounterParamName(String hdfsCounterParamName) {
        this.hdfsCounterParamName = hdfsCounterParamName;
    }
}

