/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.msro.workflows.nodes.hadoop;

import com.google.common.collect.Sets;
import eu.dnetlib.enabling.locators.UniqueServiceLocator;
import eu.dnetlib.msro.workflows.graph.Arc;
import eu.dnetlib.msro.workflows.nodes.SimpleJobNode;
import eu.dnetlib.msro.workflows.procs.Env;
import eu.dnetlib.rmi.data.hadoop.HadoopService;
import eu.dnetlib.rmi.data.hadoop.HadoopServiceException;
import eu.dnetlib.rmi.manager.MSROException;
import java.util.HashSet;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PrepareCopyTableJobNode
extends SimpleJobNode {
    private static final String ZOOKEEPER_ZNODE_PARENT = "zookeeper.znode.parent";
    private static final String HBASE_ZOOKEEPER_CLIENT_PORT = "hbase.zookeeper.client.port";
    private static final String HBASE_ZOOKEEPER_QUORUM = "hbase.zookeeper.quorum";
    private static final Log log = LogFactory.getLog(PrepareCopyTableJobNode.class);
    private String sourceCluster;
    private String targetCluster;
    private String sourceTable;
    private String targetTable;
    @Resource
    private UniqueServiceLocator serviceLocator;

    protected String execute(Env env) throws Exception {
        this.checkNodeParams();
        String outputQuorum = this.getOutputQuorum();
        log.info((Object)("build hbase quorum: " + outputQuorum));
        env.setAttribute("peer.adr", (Object)outputQuorum);
        env.setAttribute("sourceCluster", (Object)this.getSourceCluster());
        env.setAttribute("sourceTable", (Object)this.getSourceTable());
        env.setAttribute("targetCluster", (Object)this.getTargetCluster());
        env.setAttribute("targetTable", (Object)this.getTargetTable());
        return Arc.DEFAULT_ARC;
    }

    private String getOutputQuorum() throws HadoopServiceException, MSROException {
        Map conf = ((HadoopService)this.serviceLocator.getService(HadoopService.class)).getClusterConfiguration(this.getTargetCluster());
        log.debug((Object)conf);
        String hbaseQuorum = (String)conf.get(HBASE_ZOOKEEPER_QUORUM);
        String hbasePort = (String)conf.get(HBASE_ZOOKEEPER_CLIENT_PORT);
        String znodeParent = (String)conf.get(ZOOKEEPER_ZNODE_PARENT);
        this.checkParamExist(hbaseQuorum, String.format("unable to find property '%s' in cluster configuration: %s", HBASE_ZOOKEEPER_QUORUM, hbaseQuorum));
        this.checkParamExist(hbasePort, String.format("unable to find property '%s' in cluster configuration: %s", HBASE_ZOOKEEPER_CLIENT_PORT, hbasePort));
        this.checkParamExist(znodeParent, String.format("unable to find property '%s' in cluster configuration: %s", ZOOKEEPER_ZNODE_PARENT, znodeParent));
        String outputQuorum = String.format("%s:%s:%s", hbaseQuorum, hbasePort, znodeParent);
        return outputQuorum;
    }

    private void checkNodeParams() throws MSROException, HadoopServiceException {
        this.checkParamExist(this.getSourceCluster(), "source cluster must be set");
        this.checkParamExist(this.getTargetCluster(), "target cluster must be set");
        this.checkParamExist(this.getSourceTable(), "source table must be set");
        this.checkParamExist(this.getTargetTable(), "target table must be set");
        HadoopService hadoop = (HadoopService)this.serviceLocator.getService(HadoopService.class);
        HashSet clusters = Sets.newHashSet((Iterable)hadoop.listClusters());
        if (!clusters.contains(this.getSourceCluster())) {
            throw new MSROException(String.format("source cluster '%s' doesn not exists", this.getSourceCluster()));
        }
        if (!clusters.contains(this.getTargetCluster())) {
            throw new MSROException(String.format("target cluster '%s' doesn not exists", this.getTargetCluster()));
        }
        if (!hadoop.existHbaseTable(this.getSourceCluster(), this.getSourceTable())) {
            throw new MSROException(String.format("source table '%s' doesn not exists on cluster '%s'", this.getSourceTable(), this.getSourceCluster()));
        }
    }

    private void checkParamExist(String param, String msg) throws MSROException {
        if (StringUtils.isBlank((CharSequence)param)) {
            throw new MSROException(msg);
        }
    }

    public String getSourceCluster() {
        return this.sourceCluster;
    }

    public void setSourceCluster(String sourceCluster) {
        this.sourceCluster = sourceCluster;
    }

    public String getTargetCluster() {
        return this.targetCluster;
    }

    public void setTargetCluster(String targetCluster) {
        this.targetCluster = targetCluster;
    }

    public String getSourceTable() {
        return this.sourceTable;
    }

    public void setSourceTable(String sourceTable) {
        this.sourceTable = sourceTable;
    }

    public String getTargetTable() {
        return this.targetTable;
    }

    public void setTargetTable(String targetTable) {
        this.targetTable = targetTable;
    }
}

