/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.msro.workflows.nodes.hadoop;

import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import eu.dnetlib.enabling.locators.UniqueServiceLocator;
import eu.dnetlib.msro.workflows.nodes.SimpleJobNode;
import eu.dnetlib.msro.workflows.procs.Env;
import eu.dnetlib.rmi.data.hadoop.ClusterName;
import eu.dnetlib.rmi.data.hadoop.HadoopService;
import eu.dnetlib.rmi.enabling.ISLookUpException;
import eu.dnetlib.rmi.enabling.ISLookUpService;
import eu.dnetlib.rmi.manager.MSROException;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import javax.annotation.Resource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Required;

public abstract class PrepareIISParams
extends SimpleJobNode {
    private static final Log log = LogFactory.getLog(PrepareIISParams.class);
    @Resource
    private UniqueServiceLocator serviceLocator;
    private String clusterName;
    private String clusterParam = "cluster";
    private String zkQuorumParam = "export_action_hbase_remote_zookeeper_quorum";
    private String zkPortParam = "export_action_hbase_remote_zookeeper_clientport";
    private String oozieWfAppPath;
    private String oozieWfAppPathParam = "oozie.wf.application.path";
    private String xqueryMdStoreService;
    private String mdStoreStoreLocationParam = "import_mdstore_service_location";
    private String xqueryObjectStoreService;
    private String objectStoreLocationParam = "import_content_object_store_location";
    private String xqueryIsLookupService;
    private String islookupLocationParam = "import_islookup_service_location";
    private String importProjectConceptsContextIdParam = "import_project_concepts_context_id";
    private String importProjectConceptsContextId;
    private String xqueryDatasetStore;
    private String mdStoreDatasetParam = "import_dataset_mdstore_ids_csv";
    private String objectStoreBlacklistCSV = "";

    protected void prepare(Env env) throws Exception {
        env.setAttribute(this.getClusterParam(), (Object)this.getClusterName());
        env.setAttribute(this.getMdStoreStoreLocationParam(), (Object)this.getServiceEndpoint(this.getXqueryMdStoreService()));
        env.setAttribute(this.getObjectStoreLocationParam(), (Object)this.getServiceEndpoint(this.getXqueryObjectStoreService()));
        env.setAttribute(this.getIslookupLocationParam(), (Object)this.getServiceEndpoint(this.getXqueryIsLookupService()));
        env.setAttribute(this.getImportProjectConceptsContextIdParam(), (Object)this.getImportProjectConceptsContextId());
        Map conf = ((HadoopService)this.serviceLocator.getService(HadoopService.class)).getClusterConfiguration(this.getClusterName());
        Map exportConf = ((HadoopService)this.serviceLocator.getService(HadoopService.class)).getClusterConfiguration(ClusterName.DM.toString());
        String zkPort = (String)exportConf.get("hbase.zookeeper.property.clientPort");
        String zkQuorum = this.getZkQuorumCSV(exportConf, zkPort);
        env.setAttribute(this.getZkQuorumParam(), (Object)zkQuorum);
        env.setAttribute(this.getZkPortParam(), (Object)zkPort);
        String nameNode = (String)conf.get("fs.defaultFS");
        env.setAttribute("nameNode", (Object)nameNode);
        env.setAttribute("jobTracker", conf.get("mapred.job.tracker"));
        env.setAttribute(this.getOozieWfAppPathParam(), (Object)this.getURI(nameNode, this.getOozieWfAppPath()));
        env.setAttribute(this.getMdStoreDatasetParam(), (Object)this.asCSV(this.getProfileIds(this.getXqueryDatasetStore())));
    }

    protected String getServiceEndpoint(String xquery) throws MSROException {
        try {
            return (String)Iterables.getOnlyElement((Iterable)((ISLookUpService)this.serviceLocator.getService(ISLookUpService.class)).quickSearchProfile(xquery));
        }
        catch (ISLookUpException e) {
            throw new MSROException("unable to fetch service endpoint", (Throwable)e);
        }
        catch (NoSuchElementException e) {
            throw new MSROException("unable to find service endpoint, xquery: " + this.getXqueryMdStoreService(), (Throwable)e);
        }
        catch (IllegalArgumentException e) {
            throw new MSROException("more than one services found, we assume to have only one available", (Throwable)e);
        }
    }

    protected String getProfileId(String xquery) throws MSROException {
        try {
            return (String)Iterables.getOnlyElement((Iterable)((ISLookUpService)this.serviceLocator.getService(ISLookUpService.class)).quickSearchProfile(xquery));
        }
        catch (ISLookUpException e) {
            throw new MSROException("unable to fetch profile id", (Throwable)e);
        }
        catch (NoSuchElementException e) {
            throw new MSROException("unable to find profile profile, xquery: " + xquery, (Throwable)e);
        }
        catch (IllegalArgumentException e) {
            throw new MSROException("more than one profile profiles was found, we assume to have only one available, xquery: " + xquery, (Throwable)e);
        }
    }

    protected List<String> getProfileIds(String xquery) throws MSROException {
        try {
            List ids = ((ISLookUpService)this.serviceLocator.getService(ISLookUpService.class)).quickSearchProfile(xquery);
            if (ids.isEmpty()) {
                log.warn((Object)("couldn't find any profile, xquery: " + xquery));
            }
            return ids;
        }
        catch (ISLookUpException e) {
            throw new MSROException("unable to fetch profile ids, x query: " + xquery, (Throwable)e);
        }
    }

    protected String getFilteredObjectStoreCSV(String xquery) throws MSROException {
        return this.asCSV(this.filter(this.getProfileIds(xquery), this.asList(this.getObjectStoreBlacklistCSV())));
    }

    protected List<String> filter(List<String> list, List<String> filter) {
        if (filter == null || filter.isEmpty()) {
            return list;
        }
        list.removeAll(filter);
        return list;
    }

    protected String asCSV(List<String> list) {
        return Joiner.on((String)",").skipNulls().join(list);
    }

    protected List<String> asList(String csv) {
        return Lists.newArrayList((Iterable)Splitter.on((String)",").trimResults().omitEmptyStrings().split((CharSequence)csv));
    }

    private String getURI(String nameNode, String relative) {
        return nameNode + relative;
    }

    private String getZkQuorumCSV(Map<String, String> conf, String zkPort) {
        return Joiner.on((String)(":" + zkPort + ",")).join(Splitter.on((String)",").omitEmptyStrings().split((CharSequence)conf.get("hbase.zookeeper.quorum")));
    }

    @Required
    public void setXqueryMdStoreService(String xqueryMdStoreService) {
        this.xqueryMdStoreService = xqueryMdStoreService;
    }

    public String getXqueryMdStoreService() {
        return this.xqueryMdStoreService;
    }

    public String getMdStoreStoreLocationParam() {
        return this.mdStoreStoreLocationParam;
    }

    public void setMdStoreStoreLocationParam(String mdStoreStoreLocationParam) {
        this.mdStoreStoreLocationParam = mdStoreStoreLocationParam;
    }

    public String getClusterName() {
        return this.clusterName;
    }

    public void setClusterName(String clusterName) {
        this.clusterName = clusterName;
    }

    public String getZkQuorumParam() {
        return this.zkQuorumParam;
    }

    public void setZkQuorumParam(String zkQuorumParam) {
        this.zkQuorumParam = zkQuorumParam;
    }

    public String getZkPortParam() {
        return this.zkPortParam;
    }

    public void setZkPortParam(String zkPortParam) {
        this.zkPortParam = zkPortParam;
    }

    public String getClusterParam() {
        return this.clusterParam;
    }

    public void setClusterParam(String clusterParam) {
        this.clusterParam = clusterParam;
    }

    public String getOozieWfAppPathParam() {
        return this.oozieWfAppPathParam;
    }

    public void setOozieWfAppPathParam(String oozieWfAppPathParam) {
        this.oozieWfAppPathParam = oozieWfAppPathParam;
    }

    public String getOozieWfAppPath() {
        return this.oozieWfAppPath;
    }

    public void setOozieWfAppPath(String oozieWfAppPath) {
        this.oozieWfAppPath = oozieWfAppPath;
    }

    @Required
    public String getXqueryDatasetStore() {
        return this.xqueryDatasetStore;
    }

    public void setXqueryDatasetStore(String xqueryDatasetStore) {
        this.xqueryDatasetStore = xqueryDatasetStore;
    }

    public String getMdStoreDatasetParam() {
        return this.mdStoreDatasetParam;
    }

    public void setMdStoreDatasetParam(String mdStoreDatasetParam) {
        this.mdStoreDatasetParam = mdStoreDatasetParam;
    }

    public String getXqueryObjectStoreService() {
        return this.xqueryObjectStoreService;
    }

    @Required
    public void setXqueryObjectStoreService(String xqueryObjectStoreService) {
        this.xqueryObjectStoreService = xqueryObjectStoreService;
    }

    public String getObjectStoreLocationParam() {
        return this.objectStoreLocationParam;
    }

    public void setObjectStoreLocationParam(String objectStoreLocationParam) {
        this.objectStoreLocationParam = objectStoreLocationParam;
    }

    public String getObjectStoreBlacklistCSV() {
        return this.objectStoreBlacklistCSV;
    }

    public void setObjectStoreBlacklistCSV(String objectStoreBlacklistCSV) {
        this.objectStoreBlacklistCSV = objectStoreBlacklistCSV;
    }

    public String getXqueryIsLookupService() {
        return this.xqueryIsLookupService;
    }

    @Required
    public void setXqueryIsLookupService(String xqueryIsLookupService) {
        this.xqueryIsLookupService = xqueryIsLookupService;
    }

    public String getIslookupLocationParam() {
        return this.islookupLocationParam;
    }

    public void setIslookupLocationParam(String islookupLocationParam) {
        this.islookupLocationParam = islookupLocationParam;
    }

    public String getImportProjectConceptsContextIdParam() {
        return this.importProjectConceptsContextIdParam;
    }

    public void setImportProjectConceptsContextIdParam(String importProjectConceptsContextIdParam) {
        this.importProjectConceptsContextIdParam = importProjectConceptsContextIdParam;
    }

    public String getImportProjectConceptsContextId() {
        return this.importProjectConceptsContextId;
    }

    public void setImportProjectConceptsContextId(String importProjectConceptsContextId) {
        this.importProjectConceptsContextId = importProjectConceptsContextId;
    }
}

