/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.msro.workflows.nodes.index;

import eu.dnetlib.enabling.locators.UniqueServiceLocator;
import eu.dnetlib.miscutils.functional.xml.ApplyXslt;
import eu.dnetlib.rmi.enabling.ISLookUpException;
import eu.dnetlib.rmi.enabling.ISLookUpService;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.io.StringWriter;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.io.IOUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.core.io.ClassPathResource;

public class OafToIndexRecordFactory {
    private ClassPathResource layoutToRecord;
    @Autowired
    private UniqueServiceLocator serviceLocator;

    public ApplyXslt newTransformer(String format) throws IOException, TransformerException, ISLookUpException {
        StreamResult layoutToXsltXslt = this.getTransformer(format);
        return new ApplyXslt(layoutToXsltXslt.getWriter().toString());
    }

    private StreamResult getTransformer(String format) throws IOException, TransformerException, ISLookUpException {
        TransformerFactory factory = TransformerFactory.newInstance();
        Transformer layoutTransformer = factory.newTransformer(this.readLayoutToRecord());
        StreamResult layoutToXsltXslt = new StreamResult(new StringWriter());
        layoutTransformer.setParameter("format", format);
        layoutTransformer.transform(new StreamSource(new StringReader(this.getLayoutSource(format))), layoutToXsltXslt);
        return layoutToXsltXslt;
    }

    private StreamSource readLayoutToRecord() throws IOException {
        return new StreamSource(new StringReader(IOUtils.toString((InputStream)this.layoutToRecord.getInputStream())));
    }

    private String getLayoutSource(String format) throws ISLookUpException {
        return ((ISLookUpService)this.serviceLocator.getService(ISLookUpService.class)).getResourceProfileByQuery("collection('/db/DRIVER/MDFormatDSResources/MDFormatDSResourceType')[.//NAME='" + format + "']//LAYOUT[@name='index']");
    }

    public ClassPathResource getLayoutToRecord() {
        return this.layoutToRecord;
    }

    @Required
    public void setLayoutToRecord(ClassPathResource layoutToRecord) {
        this.layoutToRecord = layoutToRecord;
    }
}

