/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.msro.workflows.nodes.stats;

import eu.dnetlib.enabling.locators.UniqueServiceLocator;
import eu.dnetlib.msro.workflows.nodes.SimpleJobNode;
import eu.dnetlib.msro.workflows.procs.Env;
import eu.dnetlib.rmi.enabling.ISLookUpException;
import eu.dnetlib.rmi.enabling.ISLookUpService;
import eu.dnetlib.rmi.manager.MSROException;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Value;

public class FindStatsServiceJobNode
extends SimpleJobNode {
    private static final Log log = LogFactory.getLog(FindStatsServiceJobNode.class);
    @Resource
    private UniqueServiceLocator serviceLocator;
    @Value(value="${dnet.openaire.service.stats.lookup.xquery}")
    private String xquery;
    private String xqueryForServiceIdParam;

    public String execute(Env env) throws ISLookUpException, MSROException {
        log.info((Object)("lookup for stats service: " + this.getXquery()));
        List statsServiceIds = ((ISLookUpService)this.serviceLocator.getService(ISLookUpService.class)).quickSearchProfile(this.getXquery());
        if (statsServiceIds.size() > 1) {
            throw new MSROException("too many stats services: " + statsServiceIds);
        }
        if (statsServiceIds.isEmpty()) {
            return "notFound";
        }
        env.setAttribute(this.getXqueryForServiceIdParam(), (Object)this.getXquery());
        return "found";
    }

    public String getXquery() {
        return this.xquery;
    }

    public void setXquery(String xquery) {
        this.xquery = xquery;
    }

    public String getXqueryForServiceIdParam() {
        return this.xqueryForServiceIdParam;
    }

    public void setXqueryForServiceIdParam(String xqueryForServiceIdParam) {
        this.xqueryForServiceIdParam = xqueryForServiceIdParam;
    }
}

