package eu.dnetlib.msro.workflows.nodes;

import org.antlr.stringtemplate.StringTemplate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;

import eu.dnetlib.enabling.locators.UniqueServiceLocator;
import eu.dnetlib.enabling.resultset.factory.ResultSetFactory;
import eu.dnetlib.miscutils.functional.xml.ApplyXslt;
import eu.dnetlib.msro.workflows.graph.Arc;
import eu.dnetlib.msro.workflows.procs.Env;
import eu.dnetlib.rmi.common.ResultSet;
import eu.dnetlib.rmi.enabling.ISLookUpException;
import eu.dnetlib.rmi.enabling.ISLookUpService;
import eu.dnetlib.rmi.manager.MSROException;

public class OpenaireMdBuilderJobNode extends SimpleJobNode {

	private static final Log log = LogFactory.getLog(OpenaireMdBuilderJobNode.class);

	private StringTemplate mdBuilderTemplateXslt;

	private String inputEprParam;
	private String outputEprParam;
	private String datasourceId;
	private String datasourceInterface;

	private boolean inferred = false;
	private boolean deletedbyinference = false;
	private String inferenceprovenance = "";
	private String trust = "";
	private String provenanceactionclassname = "";
	private String provenanceactionclassid = "";

	private String overridingMetadataIdentifierXPath = "";

	@Autowired
	private ResultSetFactory resultSetFactory;

	@Autowired
	private UniqueServiceLocator serviceLocator;

	@Override
	protected String execute(final Env env) throws MSROException {
		final ResultSet<?> inputEpr = env.getAttribute(this.inputEprParam, ResultSet.class);

		if (inputEpr == null) { throw new MSROException("InputEprParam (" + this.inputEprParam + ") not found in ENV"); }

		try {
			final StringTemplate st = new StringTemplate(getMdBuilderTemplateXslt().getTemplate());

			st.setAttribute("xpath", getMetadataIdentifierXPath());
			st.setAttribute("datasourceId", this.datasourceId);
			if (env.hasAttribute("namespacePrefix")) {
				st.setAttribute("namespacePrefix", env.getAttribute("namespacePrefix"));
			} else {
				st.setAttribute("namespacePrefix", this.datasourceId);
			}

			st.setAttribute("inferred", String.valueOf(getInferred()));
			st.setAttribute("deletedbyinference", String.valueOf(getDeletedbyinference()));
			st.setAttribute("inferenceprovenance", getInferenceprovenance());
			st.setAttribute("trust", getTrust());
			st.setAttribute("provenanceactionclassname", getProvenanceactionclassname());
			st.setAttribute("provenanceactionclassid", getProvenanceactionclassid());
			st.setAttribute("baseurl", getBaseUrl());
			st.setAttribute("metadatanamespace", getMetadataNamespace());

			final ResultSet<String> epr = this.resultSetFactory.map(inputEpr, String.class, new ApplyXslt(st.toString()));

			env.setAttribute(this.outputEprParam, epr);

			return Arc.DEFAULT_ARC;
		} catch (final ISLookUpException e) {
			throw new MSROException("Error while initializing mdBuilder template for datasource " + this.datasourceId, e);
		}
	}

	private String getMetadataIdentifierXPath() throws ISLookUpException {
		final String xQuery =
				String.format("for $x in collection('/db/DRIVER/RepositoryServiceResources/RepositoryServiceResourceType') "
						+ "return $x//INTERFACE[@id='%s']/INTERFACE_EXTRA_FIELD[@name='metadata_identifier_path']/string()", getDatasourceInterface());

		return hasOverridingMetadataIdentifierXPath() ? getOverridingMetadataIdentifierXPath() : this.serviceLocator.getService(ISLookUpService.class)
				.getResourceProfileByQuery(xQuery);
	}

	private String getBaseUrl() throws ISLookUpException {
		String xQuery = "/*[.//RESOURCE_IDENTIFIER/@value='{datasourceId}']//INTERFACE[@id='{interfaceId}']//BASE_URL/string()";
		xQuery = xQuery.replace("{interfaceId}", this.datasourceInterface).replace("{datasourceId}", this.datasourceId);
		return this.serviceLocator.getService(ISLookUpService.class).getResourceProfileByQuery(xQuery);
	}

	private String getMetadataNamespace() {
		try {
			String xQuery =
					"let $x := /*[.//RESOURCE_IDENTIFIER/@value='{datasourceId}']//INTERFACE[@id='{interfaceId}']/ACCESS_PROTOCOL/@format/string() "
							+ "return /*[.//RESOURCE_TYPE/@value='MetadataFormatDSResourceType']//METADATAFORMAT[@Prefix=$x]/@NameSpace/string()";
			xQuery = xQuery.replace("{interfaceId}", this.datasourceInterface).replace("{datasourceId}", this.datasourceId);
			return this.serviceLocator.getService(ISLookUpService.class).getResourceProfileByQuery(xQuery);
		} catch (final ISLookUpException e) {
			log.error("The interface is not OAI or the format is not found in the MetadataFormatDSResourceType, thus metadata format in the <about> section "
					+ "cannot managed here and it will be leaved empty (for the time being)");
			return "";
		}
	}

	private boolean hasOverridingMetadataIdentifierXPath() {
		return !getOverridingMetadataIdentifierXPath().isEmpty();
	}

	public String getInputEprParam() {
		return this.inputEprParam;
	}

	public void setInputEprParam(final String inputEprParam) {
		this.inputEprParam = inputEprParam;
	}

	public String getOutputEprParam() {
		return this.outputEprParam;
	}

	public void setOutputEprParam(final String outputEprParam) {
		this.outputEprParam = outputEprParam;
	}

	public String getDatasourceId() {
		return this.datasourceId;
	}

	public void setDatasourceId(final String datasourceId) {
		this.datasourceId = datasourceId;
	}

	public String getDatasourceInterface() {
		return this.datasourceInterface;
	}

	public void setDatasourceInterface(final String datasourceInterface) {
		this.datasourceInterface = datasourceInterface;
	}

	public StringTemplate getMdBuilderTemplateXslt() {
		return this.mdBuilderTemplateXslt;
	}

	public void setMdBuilderTemplateXslt(final StringTemplate mdBuilderTemplateXslt) {
		this.mdBuilderTemplateXslt = mdBuilderTemplateXslt;
	}

	public boolean getInferred() {
		return this.inferred;
	}

	public void setInferred(final boolean inferred) {
		this.inferred = inferred;
	}

	public boolean getDeletedbyinference() {
		return this.deletedbyinference;
	}

	public void setDeletedbyinference(final boolean deletedbyinference) {
		this.deletedbyinference = deletedbyinference;
	}

	public String getInferenceprovenance() {
		return this.inferenceprovenance;
	}

	public void setInferenceprovenance(final String inferenceprovenance) {
		this.inferenceprovenance = inferenceprovenance;
	}

	public String getTrust() {
		return this.trust;
	}

	public void setTrust(final String trust) {
		this.trust = trust;
	}

	public String getProvenanceactionclassname() {
		return this.provenanceactionclassname;
	}

	public void setProvenanceactionclassname(final String provenanceactionclassname) {
		this.provenanceactionclassname = provenanceactionclassname;
	}

	public String getProvenanceactionclassid() {
		return this.provenanceactionclassid;
	}

	public void setProvenanceactionclassid(final String provenanceactionclassid) {
		this.provenanceactionclassid = provenanceactionclassid;
	}

	public String getOverridingMetadataIdentifierXPath() {
		return this.overridingMetadataIdentifierXPath;
	}

	public void setOverridingMetadataIdentifierXPath(final String overridingMetadataIdentifierXPath) {
		this.overridingMetadataIdentifierXPath = overridingMetadataIdentifierXPath;
	}

}
