package eu.dnetlib.msro.workflows.nodes.actionmanager;

import org.apache.commons.lang3.StringUtils;

import eu.dnetlib.enabling.tools.blackboard.BlackboardJob;
import eu.dnetlib.msro.workflows.nodes.BlackboardJobNode;
import eu.dnetlib.msro.workflows.procs.Env;
import eu.dnetlib.msro.workflows.procs.Token;
import eu.dnetlib.rmi.data.hadoop.actionmanager.ActionManagerService;

/**
 * Created by claudio on 14/04/16.
 */
public class PromoteActionsHDFSJobNode extends BlackboardJobNode {

	public static final String ALL_SETS = "ALL SETS";

	private String set;

	private String tableName;

	@Override
	protected String obtainServiceId(final Env env) {
		return getServiceLocator().getServiceId(ActionManagerService.class);
	}

	@Override
	protected void prepareJob(final BlackboardJob job, final Token token) throws Exception {
		job.setAction("PROMOTE_FROM_HDFS");
		if (!StringUtils.isBlank(getSet()) && !getSet().equals(ALL_SETS)) {
			job.getParameters().put("set", getSet());
			token.getEnv().setAttribute("set", getSet());
		}

		job.getParameters().put("targetTable", getTableName());
	}

	public String getSet() {
		return this.set;
	}

	public void setSet(final String set) {
		this.set = set;
	}

	public String getTableName() {
		return tableName;
	}

	public void setTableName(final String tableName) {
		this.tableName = tableName;
	}
}
