package eu.dnetlib.msro.workflows.nodes.actionmanager;

import java.io.StringReader;
import java.util.List;
import java.util.Map;

import javax.annotation.Resource;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

import com.google.gson.Gson;

import eu.dnetlib.enabling.locators.UniqueServiceLocator;
import eu.dnetlib.miscutils.datetime.DateUtils;
import eu.dnetlib.msro.workflows.graph.Arc;
import eu.dnetlib.msro.workflows.nodes.SimpleJobNode;
import eu.dnetlib.msro.workflows.procs.Env;
import eu.dnetlib.rmi.enabling.ISLookUpService;
import eu.dnetlib.rmi.enabling.ISRegistryService;
import eu.dnetlib.rmi.manager.MSROException;

public class UpdateSetsJobNode extends SimpleJobNode {

	/**
	 * logger.
	 */
	private static final Log log = LogFactory.getLog(UpdateSetsJobNode.class);

	@Resource
	private UniqueServiceLocator serviceLocator;

	@Override
	protected String execute(final Env env) throws Exception {

		@SuppressWarnings("unchecked")
		final List<Map<String, String>> sets = new Gson().fromJson(env.getAttribute("sets", String.class), List.class);

		final String lastUpdate = DateUtils.now_ISO8601();
		for (final Map<String, String> set : sets) {

			// update only the enabled sets.
			if (isEnabled(set)) {
				log.info("updating set: " + set.toString());
				addLatestRawSet(set, lastUpdate);
			} else {
				log.info("skip set update: " + set.toString());
			}
		}

		return Arc.DEFAULT_ARC;
	}

	private boolean isEnabled(final Map<String, String> set) {
		return set.containsKey("enabled") && set.get("enabled").equals("true");
	}

	public void addLatestRawSet(final Map<String, String> set, final String lastUpdate) throws MSROException {
		final String q = "for $x in collection('/db/DRIVER/ActionManagerSetDSResources/ActionManagerSetDSResourceType') where $x//SET/@id = '" + set.get("set")
				+ "' return $x";
		try {
			final String profile = this.serviceLocator.getService(ISLookUpService.class).getResourceProfileByQuery(q);
			final Document doc = new SAXReader().read(new StringReader(profile));
			final String profId = doc.valueOf("//RESOURCE_IDENTIFIER/@value");
			final Element latest = (Element) doc.selectSingleNode("//RAW_SETS/LATEST");
			final Element expired = ((Element) doc.selectSingleNode("//RAW_SETS")).addElement("EXPIRED");

			for (final Object o : latest.attributes()) {
				final Attribute a = (Attribute) o;
				expired.addAttribute(a.getName(), a.getValue());
			}

			latest.addAttribute("id", set.get("rawset"));
			latest.addAttribute("creationDate", set.get("creationDate"));
			latest.addAttribute("lastUpdate", lastUpdate);

			this.serviceLocator.getService(ISRegistryService.class).updateProfile(profId, doc.asXML(), "ActionManagerSetDSResourceType");
		} catch (final Exception e) {
			final String msg = "Error updating profile of set: " + set;
			log.error(msg);
			throw new MSROException(msg, e);
		}
	}

}
