package eu.dnetlib.msro.workflows.nodes.contexts;

import java.util.Map;
import java.util.Map.Entry;

import org.dom4j.DocumentHelper;
import org.dom4j.Element;

import com.google.common.collect.Maps;

public class ContextPart {

	private String id;
	private String label;
	private Map<String, String> params = Maps.newLinkedHashMap();
	private Map<String, ContextPart> parts = Maps.newLinkedHashMap();

	public ContextPart() {}

	public ContextPart(final String id, final String label) {
		this.id = id;
		this.label = label;
	}

	public String getId() {
		return id;
	}

	public void setId(final String id) {
		this.id = id;
	}

	public String getLabel() {
		return label;
	}

	public void setLabel(final String label) {
		this.label = label;
	}

	public Map<String, String> getParams() {
		return params;
	}

	public void setParams(final Map<String, String> params) {
		this.params = params;
	}

	public Map<String, ContextPart> getParts() {
		return parts;
	}

	public void setParts(final Map<String, ContextPart> parts) {
		this.parts = parts;
	}

	public void addPart(final ContextPart part) {
		if (parts.containsKey(part.getId())) {
			final ContextPart localChild = getParts().get(part.getId());
			for (ContextPart child : part.getParts().values()) {
				localChild.addPart(child);
			}
		} else {
			parts.put(part.getId(), part);
		}
	}

	public Element asDomElement(final String name) {
		final Element elem = DocumentHelper.createElement(name);
		elem.addAttribute("id", id);
		elem.addAttribute("label", label);
		elem.addAttribute("claim", "false");
		for (Entry<String, String> e : params.entrySet()) {
			final Element p = elem.addElement("param");
			p.addAttribute("name", e.getKey());
			p.setText(e.getValue());
		}
		for (ContextPart child : parts.values()) {
			elem.add(child.asDomElement("concept"));
		}
		return elem;
	}
}
