package eu.dnetlib.msro.workflows.nodes.contexts;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;

import com.google.common.collect.Iterables;

import eu.dnetlib.enabling.resultset.factory.ResultSetFactory;
import eu.dnetlib.msro.workflows.graph.Arc;
import eu.dnetlib.msro.workflows.nodes.SimpleJobNode;
import eu.dnetlib.msro.workflows.procs.Env;
import eu.dnetlib.rmi.common.ResultSet;

public class PrepareContextDbEntriesJobNode extends SimpleJobNode {

	private String contextObj;
	private String eprParam;

	private static final Log log = LogFactory.getLog(PrepareContextDbEntriesJobNode.class);

	@Autowired
	private ResultSetFactory resultSetFactory;

	@Override
	protected String execute(final Env env) throws Exception {

		final ContextDesc desc = env.getAttribute(this.contextObj, ContextDesc.class);

		final Iterable<String> iter = Iterables.transform(desc.getDbEntries().entrySet(), ContextUtils.getContextRowTransformer());
		final ResultSet<String> epr = this.resultSetFactory.createResultSet(iter);

		env.setAttribute(this.eprParam, epr.toString());

		return Arc.DEFAULT_ARC;
	}

	public String getContextObj() {
		return this.contextObj;
	}

	public void setContextObj(final String contextObj) {
		this.contextObj = contextObj;
	}

	public String getEprParam() {
		return this.eprParam;
	}

	public void setEprParam(final String eprParam) {
		this.eprParam = eprParam;
	}

}
