package eu.dnetlib.msro.workflows.nodes.contexts;

import java.io.StringReader;
import java.util.List;

import javax.annotation.Resource;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;

import eu.dnetlib.enabling.locators.UniqueServiceLocator;
import eu.dnetlib.msro.workflows.graph.Arc;
import eu.dnetlib.msro.workflows.nodes.SimpleJobNode;
import eu.dnetlib.msro.workflows.procs.Env;
import eu.dnetlib.rmi.enabling.ISLookUpService;
import eu.dnetlib.rmi.enabling.ISRegistryException;
import eu.dnetlib.rmi.enabling.ISRegistryService;

public class SaveContextProfileJobNode extends SimpleJobNode {

	private String contextObj;

	private static final Log log = LogFactory.getLog(SaveContextProfileJobNode.class);

	@Resource
	private UniqueServiceLocator serviceLocator;

	@Override
	protected String execute(final Env env) throws Exception {
		final ContextDesc desc = env.getAttribute(this.contextObj, ContextDesc.class);

		final String xquery = "for $x in collection('/db/DRIVER/ContextDSResources/ContextDSResourceType') " + "where $x//CONFIGURATION/context[@id='"
				+ desc.getId() + "' " + "and @type='" + desc.getType() + "'] " + "return $x";
		final List<String> list = this.serviceLocator.getService(ISLookUpService.class).quickSearchProfile(xquery);

		if (list.isEmpty()) {
			registerNewProfile(desc);
		} else {
			updateProfile(list.get(0), desc);
		}

		return Arc.DEFAULT_ARC;
	}

	private boolean updateProfile(final String profile, final ContextDesc desc) throws DocumentException, ISRegistryException {
		final SAXReader reader = new SAXReader();
		final Document doc = reader.read(new StringReader(profile));
		final String profId = doc.valueOf("//HEADER/RESOURCE_IDENTIFIER/@value");
		final Element ctxElem = (Element) doc.selectSingleNode("//CONFIGURATION/context[@id='" + desc.getId() + "' and @type='" + desc.getType() + "']");

		for (final ContextPart cat : desc.getCategories().values()) {
			final Node catElem = ctxElem.selectSingleNode("./category[@id=\"" + cat.getId() + "\"]");
			if (catElem != null) {
				catElem.detach();
			}
			ctxElem.add(cat.asDomElement("category"));
		}
		log.info("registering profile context " + desc.getId());
		return this.serviceLocator.getService(ISRegistryService.class).updateProfile(profId, doc.asXML(), "ContextDSResourceType");
	}

	private String registerNewProfile(final ContextDesc desc) throws DocumentException, ISRegistryException {
		final SAXReader reader = new SAXReader();
		final Document doc = reader.read(getClass().getResourceAsStream(
				"/eu/dnetlib/msro/openaireplus/workflows/repo-hi/entityreg-contexts/xml/contextProfile.xml"));
		((Element) doc.selectSingleNode("//CONFIGURATION")).add(desc.asDomElement());
		log.info("updating profile context " + desc.getId());
		return this.serviceLocator.getService(ISRegistryService.class).registerProfile(doc.asXML());
	}

	public String getContextObj() {
		return this.contextObj;
	}

	public void setContextObj(final String contextObj) {
		this.contextObj = contextObj;
	}

}
