package eu.dnetlib.msro.workflows.nodes.datacite;

import java.io.StringReader;
import java.util.Iterator;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;

import eu.dnetlib.data.collector.plugins.datasets.DatasetsByJournalIterator;
import eu.dnetlib.data.collector.plugins.datasets.PangaeaJournalInfo;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.io.SAXReader;
import org.springframework.beans.factory.annotation.Autowired;

import eu.dnetlib.enabling.resultset.client.ResultSetClient;
import eu.dnetlib.enabling.resultset.factory.ResultSetFactory;
import eu.dnetlib.msro.workflows.graph.Arc;
import eu.dnetlib.msro.workflows.nodes.SimpleJobNode;
import eu.dnetlib.msro.workflows.procs.Env;
import eu.dnetlib.rmi.common.ResultSet;

// TODO: Auto-generated Javadoc
/**
 * The Class CollectDatasetsByJournalJobNode.
 */
public class CollectDatasetsByJournalJobNode extends SimpleJobNode {

	private static final Log log = LogFactory.getLog(CollectDatasetsByJournalJobNode.class);

	public static PangaeaJournalInfo END_QUEUE = new PangaeaJournalInfo();

	/** The datasource id. */
	private String datasourceId;

	/** The output epr param. */
	private String outputEprParam;

	/** The input epr param. */
	private String inputEprParam;

	/** The result set client factory. */
	@Autowired
	private ResultSetClient resultSetClient;

	/** The result set factory. */
	@Autowired
	private ResultSetFactory resultSetFactory;

	/** The executor. */
	private final Executor executor = Executors.newSingleThreadExecutor();

	/**
	 * (non-Javadoc)
	 *
	 * @see eu.dnetlib.msro.workflows.nodes.SimpleJobNode#execute(com.googlecode.sarasvati.NodeToken)
	 */
	@Override
	protected String execute(final Env env) throws Exception {
		final ResultSet<?> inputEpr = env.getAttribute(this.inputEprParam, ResultSet.class);
		final Iterable<String> input = this.resultSetClient.iter(inputEpr, String.class);
		final BlockingQueue<PangaeaJournalInfo> publicationsQueue = new ArrayBlockingQueue<PangaeaJournalInfo>(50);

		this.executor.execute(() -> {
			final SAXReader reader = new SAXReader();

			for (final String inputString : input) {
				try {
					final Document doc = reader.read(new StringReader(inputString));
					final String jId = doc.valueOf("//FIELD[@name='id']");
					final String dsId = doc.valueOf("//FIELD[@name='datasource']");
					final String dsName = doc.valueOf("//FIELD[@name='name']");
					final String jISSN = doc.valueOf("//FIELD[@name='issn']");
					final PangaeaJournalInfo info = new PangaeaJournalInfo();
					info.setDatasourceId(dsId);
					info.setJournalId(jId);
					info.setJournalName(dsName);
					info.setJournalISSN(jISSN);
					publicationsQueue.put(info);
				} catch (final Exception e) {
					log.error(e);
				}
			}
			try {
				publicationsQueue.put(END_QUEUE);
			} catch (final InterruptedException e) {
				log.error(e);
			}
		});

		final Iterator<PangaeaJournalInfo> itOnQueue =
				new IteratorOnQueue<PangaeaJournalInfo>(publicationsQueue, CollectDatasetsByJournalJobNode.END_QUEUE);

		final ResultSet<String> eprOutput = this.resultSetFactory.createResultSet(() -> new DatasetsByJournalIterator(itOnQueue));
		env.setAttribute(getOutputEprParam(), eprOutput);
		return Arc.DEFAULT_ARC;
	}

	/**
	 * Gets the datasource id.
	 *
	 * @return the datasourceId
	 */
	public String getDatasourceId() {
		return this.datasourceId;
	}

	/**
	 * Sets the datasource id.
	 *
	 * @param datasourceId
	 *            the datasourceId to set
	 */
	public void setDatasourceId(final String datasourceId) {
		this.datasourceId = datasourceId;
	}

	/**
	 * @return the outputEprParam
	 */
	public String getOutputEprParam() {
		return this.outputEprParam;
	}

	/**
	 * @param outputEprParam
	 *            the outputEprParam to set
	 */
	public void setOutputEprParam(final String outputEprParam) {
		this.outputEprParam = outputEprParam;
	}

	/**
	 * @return the inputEprParam
	 */
	public String getInputEprParam() {
		return this.inputEprParam;
	}

	/**
	 * @param inputEprParam
	 *            the inputEprParam to set
	 */
	public void setInputEprParam(final String inputEprParam) {
		this.inputEprParam = inputEprParam;
	}

}
