package eu.dnetlib.msro.workflows.nodes.datacite;

import java.util.Iterator;
import java.util.concurrent.BlockingQueue;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/**
 * The Class IteratorOnQueue.
 *
 * @param <T>
 *            the generic type
 */
public class IteratorOnQueue<T> implements Iterator<T> {

	/** The Constant log. */
	private static final Log log = LogFactory.getLog(IteratorOnQueue.class);

	/** The input queue. */
	private final BlockingQueue<T> inputQueue;

	/** The current item. */
	private T currentItem;

	/** The end queue. */
	private T endQueue;

	/**
	 * Instantiates a new iterator on queue.
	 *
	 * @param inputQueue
	 *            the input queue
	 * @param endQueue
	 *            the end queue
	 */
	public IteratorOnQueue(final BlockingQueue<T> inputQueue, final T endQueue) {
		this.inputQueue = inputQueue;
		this.endQueue = endQueue;

		try {
			currentItem = this.inputQueue.take();
		} catch (InterruptedException e) {
			log.error(e);
		}
	}

	/**
	 * Checks for next.
	 *
	 * @return true, if successful
	 */
	@Override
	public boolean hasNext() {

		return currentItem != this.endQueue;
	}

	/**
	 * Next.
	 *
	 * @return the t
	 */
	@Override
	public T next() {

		T previous = currentItem;
		try {
			currentItem = this.inputQueue.take();
		} catch (Exception e) {
			log.error(e);
		}
		return previous;
	}

	/**
	 * Removes the.
	 */
	@Override
	public void remove() {
		// TODO Auto-generated method stub

	}

}
