package eu.dnetlib.msro.workflows.nodes.datacite;

import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;

import org.springframework.beans.factory.annotation.Autowired;

import eu.dnetlib.enabling.resultset.client.ResultSetClient;
import eu.dnetlib.enabling.resultset.factory.ResultSetFactory;
import eu.dnetlib.msro.workflows.graph.Arc;
import eu.dnetlib.msro.workflows.nodes.SimpleJobNode;
import eu.dnetlib.msro.workflows.procs.Env;
import eu.dnetlib.rmi.common.ResultSet;

/**
 * The Class SplitDatasetRecord.
 */
public class SplitDatasetRecord extends SimpleJobNode {

	/** The input epr parm. */
	private String inputEprParm;

	/** The output epr parm. */
	private String outputEprParm;

	/** The result set client factory. */
	@Autowired
	private ResultSetClient resultSetClient;

	/** The result set factory. */
	@Autowired
	private ResultSetFactory resultSetFactory;

	/** The executor. */
	private final Executor executor = Executors.newSingleThreadExecutor();

	/*
	 * (non-Javadoc)
	 *
	 * @see eu.dnetlib.msro.workflows.nodes.SimpleJobNode#execute(com.googlecode.sarasvati.NodeToken)
	 */
	@Override
	protected String execute(final Env env) throws Exception {
		final ResultSet<?> inputEpr = env.getAttribute(this.inputEprParm, ResultSet.class);
		final Iterable<String> input = this.resultSetClient.iter(inputEpr, String.class);
		final LinkedBlockingQueue<String> publicationsQueue = new LinkedBlockingQueue<String>();
		final SplitterDatasetsIterator splitterIterator = new SplitterDatasetsIterator(publicationsQueue, input, "publications");

		this.executor.execute(new Runnable() {

			@Override
			public void run() {
				splitterIterator.populateQueues();
			}
		});

		final ResultSet<String> eprUrls_publications =
				this.resultSetFactory.createResultSet(() -> new IteratorOnQueue<String>(publicationsQueue, SplitterDatasetsIterator.END_QUEUE));

		env.setAttribute(getOutputEprParm(), eprUrls_publications);

		return Arc.DEFAULT_ARC;
	}

	/**
	 * Gets the input epr parm.
	 *
	 * @return the inputEprParm
	 */
	public String getInputEprParm() {
		return this.inputEprParm;
	}

	/**
	 * Sets the input epr parm.
	 *
	 * @param inputEprParm
	 *            the inputEprParm to set
	 */
	public void setInputEprParm(final String inputEprParm) {
		this.inputEprParm = inputEprParm;
	}

	/**
	 * Gets the output epr parm.
	 *
	 * @return the output epr parm
	 */
	public String getOutputEprParm() {
		return this.outputEprParm;
	}

	/**
	 * Sets the output epr parm.
	 *
	 * @param outputEprParm
	 *            the new output epr parm
	 */
	public void setOutputEprParm(final String outputEprParm) {
		this.outputEprParm = outputEprParm;
	}

}
