package eu.dnetlib.msro.workflows.nodes.dfm;

import java.io.IOException;

import javax.annotation.Resource;

import eu.dnetlib.monitoring.core.sensors.SensorCreationException;
import eu.dnetlib.monitoring.core.sensors.SensorFactory;
import eu.dnetlib.monitoring.core.sensors.collection.index.solr.SolrSensor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import eu.dnetlib.enabling.locators.UniqueServiceLocator;
import eu.dnetlib.msro.workflows.graph.Arc;
import eu.dnetlib.msro.workflows.nodes.SimpleJobNode;
import eu.dnetlib.msro.workflows.procs.Env;
import eu.dnetlib.rmi.enabling.ISLookUpException;

public class TriggerIndexMonitoringScenarioJobNode extends SimpleJobNode {

	private static final Log log = LogFactory.getLog(TriggerIndexMonitoringScenarioJobNode.class);
	private static final String SOLR_COLLECTION_POSTFIX = "-index-openaire";

	@Resource
	private UniqueServiceLocator serviceLocator;
	private String mdFormat;
	private SolrSensor solrSensor;

	@Override
	protected String execute(final Env env) throws IOException, InstantiationException, IllegalAccessException, InterruptedException,
			ISLookUpException, SensorCreationException {

		/* Configuring SOLR sensor */
		final String actualCollection = this.mdFormat + SOLR_COLLECTION_POSTFIX;
		log.info("Executing on " + actualCollection + " SOLR collection");
		this.solrSensor = (SolrSensor) SensorFactory.createSensorWithConfiguration(SolrSensor.class, "index", "solr2");
		this.solrSensor.getConfiguration().setParam("collection", actualCollection);
		this.solrSensor.reinitialize();
		log.info("Measuring...");
		this.solrSensor.measure();
		log.info("DONE!");
		return Arc.DEFAULT_ARC;
	}

	public String getMdFormat() {
		return this.mdFormat;
	}

	public void setMdFormat(final String mdFormat) {
		this.mdFormat = mdFormat;
	}

}
