package eu.dnetlib.msro.workflows.nodes.hadoop;

import java.util.Set;
import javax.annotation.Resource;

import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.collect.Sets;

import eu.dnetlib.enabling.locators.UniqueServiceLocator;
import eu.dnetlib.msro.workflows.nodes.SimpleJobNode;
import eu.dnetlib.msro.workflows.procs.Env;
import eu.dnetlib.rmi.manager.MSROException;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class AbstractHBaseAdminJobNode extends SimpleJobNode {

	/** The Constant log. */
	private static final Log log = LogFactory.getLog(AbstractHBaseAdminJobNode.class); // NOPMD by marko on 11/24/08 5:02 PM

	private String tableColumnsParamName = "columns";
	private String tableConfigurationParamName = "tableConf";
	private String tableName;
	private String cluster;

	@Resource
	private UniqueServiceLocator serviceLocator;

	protected Set<String> getColumns(final Env env) throws MSROException {
		String envCols = env.getAttribute(getTableColumnsParamName(), String.class);
		if (StringUtils.isBlank(envCols)) { throw new MSROException("cannot find table description"); }
		log.debug("using columns from env: " + envCols);
		return Sets.newHashSet(Splitter.on(",").omitEmptyStrings().split(envCols));
	}

	protected String asCSV(final Iterable<String> columns) {
		return Joiner.on(",").skipNulls().join(columns);
	}

	public String getCluster() {
		return cluster;
	}

	public void setCluster(final String cluster) {
		this.cluster = cluster;
	}

	public String getTableColumnsParamName() {
		return tableColumnsParamName;
	}

	public void setTableColumnsParamName(final String tableColumnsParamName) {
		this.tableColumnsParamName = tableColumnsParamName;
	}

	public UniqueServiceLocator getServiceLocator() {
		return serviceLocator;
	}

	public String getTableConfigurationParamName() {
		return tableConfigurationParamName;
	}

	public void setTableConfigurationParamName(final String tableConfigurationParamName) {
		this.tableConfigurationParamName = tableConfigurationParamName;
	}

	public String getTableName() {
		return tableName;
	}

	public void setTableName(final String tableName) {
		this.tableName = tableName;
	}
}
