package eu.dnetlib.msro.workflows.nodes.hadoop;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import eu.dnetlib.msro.workflows.graph.Arc;
import eu.dnetlib.msro.workflows.nodes.SimpleJobNode;
import eu.dnetlib.msro.workflows.procs.Env;

/**
 * The Class SetHdfsFileJobNode.
 */
public class SetHdfsFileJobNode extends SimpleJobNode {

	/**
	 * logger.
	 */
	private static final Log log = LogFactory.getLog(SetHdfsFileJobNode.class); // NOPMD by marko on 11/24/08 5:02 PM

	/** The input records path. */
	private String hdfsPath;

	/** The input records path param. */
	private String hdfsPathParam;

	/**
	 * {@inheritDoc}
	 *
	 * @see com.googlecode.sarasvati.mem.MemNode#execute(com.googlecode.sarasvati.Engine, com.googlecode.sarasvati.NodeToken)
	 */
	@Override
	public String execute(final Env env) {

		log.info("hdfs path: " + getHdfsPath());

		env.setAttribute(getHdfsPathParam(), getHdfsPath());

		return Arc.DEFAULT_ARC;
	}

	public String getHdfsPath() {
		return this.hdfsPath;
	}

	public void setHdfsPath(final String hdfsPath) {
		this.hdfsPath = hdfsPath;
	}

	public String getHdfsPathParam() {
		return this.hdfsPathParam;
	}

	public void setHdfsPathParam(final String hdfsPathParam) {
		this.hdfsPathParam = hdfsPathParam;
	}

}
