package eu.dnetlib.msro.workflows.nodes.hostedby;

import java.util.Map.Entry;

import javax.annotation.Resource;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import eu.dnetlib.enabling.locators.UniqueServiceLocator;
import eu.dnetlib.miscutils.datetime.DateUtils;
import eu.dnetlib.msro.workflows.graph.Arc;
import eu.dnetlib.msro.workflows.nodes.SimpleJobNode;
import eu.dnetlib.msro.workflows.procs.Env;
import eu.dnetlib.rmi.datasource.DatasourceDesc;
import eu.dnetlib.rmi.datasource.DatasourceManagerService;
import eu.dnetlib.rmi.datasource.DatasourceManagerServiceException;
import eu.dnetlib.rmi.datasource.IfaceDesc;

public class UpsertHostedByApisJobNode extends SimpleJobNode {

	private static final Log log = LogFactory.getLog(UpsertHostedByApisJobNode.class);

	private static final String HOSTED_BY_COMPLIANCE = "hostedBy";

	@Resource
	private UniqueServiceLocator serviceLocator;

	private String countersParam;
	private String mdId;
	public static final String extraFieldsForTotal = "last_aggregation_total";
	public static final String extraFieldForDate = "last_aggregation_date";
	public static final String extraFieldForMdId = "last_aggregation_mdId";

	@Override
	protected String execute(final Env env) throws Exception {
		final HostedByCounters counters = env.getAttribute(this.countersParam, HostedByCounters.class);
		final DatasourceManagerService dsManager = this.serviceLocator.getService(DatasourceManagerService.class);
		final String date = DateUtils.now_ISO8601();
		final String namespacePrefix = env.getAttribute("namespacePrefix", String.class);

		log.info(counters);

		for (final Entry<String, Integer> e : counters.getCounters().entrySet()) {
			updateHostedByApi(dsManager, e.getKey(), namespacePrefix, date, e.getValue());
		}

		return Arc.DEFAULT_ARC;
	}

	private void updateHostedByApi(final DatasourceManagerService dsManager,
			final String dsId,
			final String namepsacePrefix,
			final String date,
			final int size) {
		log.info("Verifying hostedBy api in ds: " + dsId);
		try {
			final DatasourceDesc ds = dsManager.getDatasource(dsId);

			for (final IfaceDesc iface : ds.getInterfaces()) {
				if (HOSTED_BY_COMPLIANCE.equals(iface.getCompliance())) {

					// dsManager.updateExtraField(dsId, iface.getId(), namepsacePrefix + ":" + extraFieldForDate, date, false);
					// dsManager.updateExtraField(dsId, iface.getId(), namepsacePrefix + ":" + extraFieldsForTotal, Integer.toString(size),
					// false);
					// dsManager.updateExtraField(dsId, iface.getId(), namepsacePrefix + ":" + extraFieldForMdId, mdId, false);
					return;
				}
			}

			final IfaceDesc iface = new IfaceDesc();
			iface.setId("api_________::" + dsId + "::hostedBy");
			iface.setTypology(ds.getDatasourceClass());
			iface.setCompliance(HOSTED_BY_COMPLIANCE);
			iface.setAccessProtocol("UNKNOWN");
			iface.setContentDescription("metadata");
			iface.setBaseUrl("");
			iface.setActive(false);
			iface.setRemovable(true);
			iface.getExtraFields().put(namepsacePrefix + ":" + extraFieldForDate, date);
			iface.getExtraFields().put(namepsacePrefix + ":" + extraFieldsForTotal, Integer.toString(size));
			iface.getExtraFields().put(namepsacePrefix + ":" + extraFieldForMdId, this.mdId);
			dsManager.addInterface(dsId, iface);
		} catch (final DatasourceManagerServiceException e) {
			log.warn("Error setting hostedBy api of ds: " + dsId, e);
		}
	}

	public String getMdId() {
		return this.mdId;
	}

	public void setMdId(final String mdId) {
		this.mdId = mdId;
	}

	public String getCountersParam() {
		return this.countersParam;
	}

	public void setCountersParam(final String countersParam) {
		this.countersParam = countersParam;
	}

}
