package eu.dnetlib.msro.workflows.nodes.index;

import java.util.List;

import javax.annotation.Resource;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Required;

import com.google.common.collect.Iterables;

import eu.dnetlib.enabling.locators.UniqueServiceLocator;
import eu.dnetlib.rmi.enabling.ISLookUpException;
import eu.dnetlib.rmi.enabling.ISLookUpService;

public class EntityGrouperConfigurationLoader {

	/**
	 * logger.
	 */
	private static final Log log = LogFactory.getLog(EntityGrouperConfigurationLoader.class); // NOPMD by marko on 11/24/08 5:02 PM

	private String xquery;

	@Resource
	private UniqueServiceLocator serviceLocator;

	public String load() throws ISLookUpException {

		log.info("loading EntityGrouperConfigurationDSResourceType: " + getXquery());

		final List<String> conf = this.serviceLocator.getService(ISLookUpService.class).quickSearchProfile(getXquery());
		if (conf == null || conf.isEmpty()) { throw new IllegalStateException("unable to read entity grouper configuration profile"); }
		if (conf.size() > 1) { throw new IllegalStateException("found more than one EntityGrouperConfigurationDSResourceType"); }

		return Iterables.getOnlyElement(conf).replaceAll("\\s+", " ").trim();
	}

	public String getXquery() {
		return this.xquery;
	}

	@Required
	public void setXquery(final String xquery) {
		this.xquery = xquery;
	}

}
