package eu.dnetlib.msro.workflows.nodes.index;

import java.util.List;

import javax.annotation.Resource;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Value;

import eu.dnetlib.enabling.locators.UniqueServiceLocator;
import eu.dnetlib.msro.workflows.nodes.SimpleJobNode;
import eu.dnetlib.msro.workflows.procs.Env;
import eu.dnetlib.rmi.enabling.ISLookUpException;
import eu.dnetlib.rmi.enabling.ISLookUpService;
import eu.dnetlib.rmi.manager.MSROException;

public class FindSearchServiceJobNode extends SimpleJobNode {

	/**
	 * logger.
	 */
	private static final Log log = LogFactory.getLog(FindSearchServiceJobNode.class); // NOPMD by marko on 11/24/08 5:02 PM

	@Resource
	private UniqueServiceLocator serviceLocator;

	@Value(value = "${dnet.openaire.service.search.lookup.xquery}")
	private String xquery;

	private String xqueryForServiceIdParam;

	/**
	 * {@inheritDoc}
	 *
	 * @throws ISLookUpException
	 * @throws MSROException
	 *
	 * @see com.googlecode.sarasvati.mem.MemNode#execute(com.googlecode.sarasvati.Engine, com.googlecode.sarasvati.NodeToken)
	 */
	@Override
	public String execute(final Env env) throws ISLookUpException, MSROException {

		log.info("lookup for search service: " + getXquery());

		final List<String> searchServiceIds = this.serviceLocator.getService(ISLookUpService.class).quickSearchProfile(getXquery());

		if (searchServiceIds.size() > 1) { throw new MSROException("too many search services: " + searchServiceIds); }

		if (searchServiceIds.isEmpty()) {
			return "notFound";
		} else {
			env.setAttribute(getXqueryForServiceIdParam(), getXquery());
			return "found";
		}
	}

	public String getXquery() {
		return this.xquery;
	}

	public void setXquery(final String xquery) {
		this.xquery = xquery;
	}

	public String getXqueryForServiceIdParam() {
		return this.xqueryForServiceIdParam;
	}

	public void setXqueryForServiceIdParam(final String xqueryForServiceIdParam) {
		this.xqueryForServiceIdParam = xqueryForServiceIdParam;
	}

}
