package eu.dnetlib.msro.workflows.nodes.index;

import java.util.List;

import org.apache.commons.lang3.StringUtils;

import eu.dnetlib.enabling.tools.blackboard.BlackboardJob;
import eu.dnetlib.msro.workflows.nodes.BlackboardJobNode;
import eu.dnetlib.msro.workflows.procs.Env;
import eu.dnetlib.msro.workflows.procs.Token;
import eu.dnetlib.rmi.enabling.ISLookUpException;
import eu.dnetlib.rmi.enabling.ISLookUpService;
import eu.dnetlib.rmi.manager.MSROException;

/**
 * SwitchIndexJobNode performs index switch.
 *
 * @author claudio
 *
 */
public class SwitchIndexJobNode extends BlackboardJobNode {

	private static final String BB_ACTION_SWITCH_INDEX = "UpdateIndex";

	private String inputIndexIdParam;

	private String outputIndexIdParam;

	private String xqueryForServiceIdParam;

	@Override
	protected String obtainServiceId(final Env env) {
		final String xquery = env.getAttribute(getXqueryForServiceIdParam(), String.class);
		List<String> searchServiceIds;
		try {
			searchServiceIds = getServiceLocator().getService(ISLookUpService.class).quickSearchProfile(xquery);
			if (searchServiceIds.size() > 1) { throw new RuntimeException("Too many SearchService ids found using query: " + xquery); }
			if (searchServiceIds.size() < 1) { throw new RuntimeException("SearchService id not found using query: " + xquery); }
			return searchServiceIds.get(0);
		} catch (final ISLookUpException e) {
			throw new RuntimeException(e);
		}
	}

	@Override
	protected void prepareJob(final BlackboardJob job, final Token token) throws Exception {
		job.setAction(BB_ACTION_SWITCH_INDEX);
		final String indexId = token.getEnv().getAttribute(getInputIndexIdParam(), String.class);

		checkParam(getInputIndexIdParam(), "output indexId param is missing");
		checkParam(indexId, "indexId is required to perform switch");

		job.getParameters().put(getOutputIndexIdParam(), indexId);
	}

	private void checkParam(final String param, final String msg) throws MSROException {
		if (StringUtils.isBlank(param)) { throw new MSROException(msg); }
	}

	public String getInputIndexIdParam() {
		return this.inputIndexIdParam;
	}

	public void setInputIndexIdParam(final String inputIndexIdParam) {
		this.inputIndexIdParam = inputIndexIdParam;
	}

	public String getOutputIndexIdParam() {
		return this.outputIndexIdParam;
	}

	public void setOutputIndexIdParam(final String outputIndexIdParam) {
		this.outputIndexIdParam = outputIndexIdParam;
	}

	public String getXqueryForServiceIdParam() {
		return this.xqueryForServiceIdParam;
	}

	public void setXqueryForServiceIdParam(final String xqueryForServiceIdParam) {
		this.xqueryForServiceIdParam = xqueryForServiceIdParam;
	}

}
