package eu.dnetlib.msro.workflows.nodes.stats;

import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import eu.dnetlib.enabling.tools.blackboard.BlackboardJob;
import eu.dnetlib.msro.workflows.procs.Token;

/**
 * Ask the StatsManagerService to promote the shadow cache so that its entries can be used by the portal specified by the additional BB
 * parameter <code>StatsManagerServiceBBAction.PROMOTE_SHADOW_CACHE.getTargetPortalParamName()</code>.
 *
 * @author alessia
 *
 */
public class PromoteShadowCacheStatsJobNode extends AbstractStatsJobNode {

	private static final Log log = LogFactory.getLog(PromoteShadowCacheStatsJobNode.class); // NOPMD by marko on 11/24/08 5:02 PM

	@Override
	protected void prepareJob(final BlackboardJob job, final Token token) throws Exception {
		job.setAction(StatsManagerServiceBBAction.PROMOTE_SHADOW_CACHE.action());
		final String portal = getPortalName(token.getEnv());
		if (StringUtils.isNotBlank(portal)) {
			job.getParameters().put(StatsManagerServiceBBAction.PROMOTE_SHADOW_CACHE.getTargetPortalParamName(), portal);
		} else {
			log.warn(StatsManagerServiceBBAction.PROMOTE_SHADOW_CACHE.getTargetPortalParamName() + " not set. The StatsManagerService will use its default.");
		}
	}

}
