package eu.dnetlib.msro.workflows.nodes.stats;

import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import eu.dnetlib.enabling.tools.blackboard.BlackboardJob;
import eu.dnetlib.msro.workflows.procs.Token;

/**
 * Ask the StatsManagerService to promote the shadow stats db and cache to public for the portal specified by the additional BB parameter
 * <code>StatsManagerServiceBBAction.PROMOTE_SHADOW_STATS.getTargetPortalParamName()</code>.
 *
 * <p>
 * According to the StatsManagerService specifications in https://issue.openaire.research-infrastructures.eu/issues/914#note-49, this BB
 * action will:
 * <ol>
 * <li>promote the shadow cache to public</li>
 * <li>make a backup of the current stats db schema under the name 'backup'</li>
 * <li>replace it with the new one</li>
 * </ol>
 * </p>
 *
 * @author alessia
 *
 */
public class PromoteShadowStatsJobNode extends AbstractStatsJobNode {

	private static final Log log = LogFactory.getLog(PromoteShadowStatsJobNode.class); // NOPMD by marko on 11/24/08 5:02 PM

	@Override
	protected void prepareJob(final BlackboardJob job, final Token token) throws Exception {
		job.setAction(StatsManagerServiceBBAction.PROMOTE_SHADOW_STATS.action());
		final String portal = getPortalName(token.getEnv());
		if (StringUtils.isNotBlank(portal)) {
			job.getParameters().put(StatsManagerServiceBBAction.PROMOTE_SHADOW_STATS.getTargetPortalParamName(), portal);
		} else {
			log.warn(StatsManagerServiceBBAction.PROMOTE_SHADOW_STATS.getTargetPortalParamName() + " not set. The StatsManagerService will use its default.");
		}
	}

}
