package eu.dnetlib.msro.workflows.nodes.utils;

import java.util.List;

import com.google.common.collect.Lists;

import eu.dnetlib.data.proto.TypeProtos.Type;
import eu.dnetlib.miscutils.collections.Pair;

public class SimilarityMeshBuilder {

	public static List<Similarity> build(final Type type, final List<String> list) {

		return build(type, list, true);
	}

	public static List<Similarity> build(final Type type, final List<String> list, final boolean addTypePrefix) {
		final String typePrefix = String.valueOf(type.getNumber());
		final List<Similarity> res = Lists.newArrayList();
		for (int i = 0; i < list.size(); i++) {
			for (int j = 0; j < list.size(); j++) {

				if (!list.get(i).equals(list.get(j))) {

					final String source = addTypePrefix ? typePrefix + "|" + list.get(i) : list.get(i);
					final String target = addTypePrefix ? typePrefix + "|" + list.get(j) : list.get(j);

					res.add(new Similarity(new Pair<String, String>(source, target), type));
				}
			}
		}
		return res;
	}
}
