/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.msro.workflows.nodes;

import eu.dnetlib.enabling.locators.UniqueServiceLocator;
import eu.dnetlib.msro.workflows.graph.Arc;
import eu.dnetlib.msro.workflows.nodes.SimpleJobNode;
import eu.dnetlib.msro.workflows.procs.Env;
import eu.dnetlib.rmi.enabling.ISLookUpService;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class LoadMappingProfileJobNode
extends SimpleJobNode {
    private static final Log log = LogFactory.getLog(LoadMappingProfileJobNode.class);
    @Autowired
    private UniqueServiceLocator serviceLocator;
    private String profileId;
    private String loadedMappingParam;

    protected String execute(Env env) throws Exception {
        log.info((Object)String.format("loading mapping from: %s", this.profileId));
        String xquery = String.format("/RESOURCE_PROFILE[.//RESOURCE_IDENTIFIER/@value='%s']/BODY/CONFIGURATION/SCRIPT/CODE/*[local-name()='stylesheet']", this.getProfileId());
        String xslt = ((ISLookUpService)this.serviceLocator.getService(ISLookUpService.class)).getResourceProfileByQuery(xquery);
        log.debug((Object)String.format("mapping: %s", xslt));
        if (StringUtils.isBlank((CharSequence)xslt)) {
            throw new IllegalStateException("unable to load mapping from profile: " + this.getProfileId());
        }
        env.setAttribute(this.getLoadedMappingParam(), (Object)xslt);
        return Arc.DEFAULT_ARC;
    }

    public String getProfileId() {
        return this.profileId;
    }

    public void setProfileId(String profileId) {
        this.profileId = profileId;
    }

    public String getLoadedMappingParam() {
        return this.loadedMappingParam;
    }

    public void setLoadedMappingParam(String loadedMappingParam) {
        this.loadedMappingParam = loadedMappingParam;
    }
}

