/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.msro.workflows.nodes;

import eu.dnetlib.enabling.locators.UniqueServiceLocator;
import eu.dnetlib.enabling.resultset.client.ResultSetClient;
import eu.dnetlib.msro.workflows.graph.Arc;
import eu.dnetlib.msro.workflows.nodes.SimpleJobNode;
import eu.dnetlib.msro.workflows.procs.Env;
import eu.dnetlib.msro.workflows.procs.Token;
import eu.dnetlib.msro.workflows.util.ProgressProvider;
import eu.dnetlib.msro.workflows.util.ResultsetProgressProvider;
import eu.dnetlib.rmi.common.ResultSet;
import eu.dnetlib.rmi.enabling.ISRegistryService;
import java.io.Reader;
import java.io.StringReader;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.io.SAXReader;
import org.springframework.beans.factory.annotation.Autowired;

public class UpdateRepositoryProfilesJobNode
extends SimpleJobNode {
    private static final String REPOSITORY_SERVICE_RESOURCE_TYPE = "RepositoryServiceResourceType";
    @Autowired
    private ResultSetClient resultSetClient;
    @Autowired
    private UniqueServiceLocator serviceLocator;
    private String eprParam = "repoEpr";
    private String existingReposParam = "existingRepos";
    private static final Log log = LogFactory.getLog(UpdateRepositoryProfilesJobNode.class);

    protected void beforeStart(Token token) {
        ResultSet epr = (ResultSet)token.getEnv().getAttribute(this.getEprParam(), ResultSet.class);
        token.setProgressProvider((ProgressProvider)new ResultsetProgressProvider(epr, this.resultSetClient));
    }

    protected String execute(Env env) throws Exception {
        Map existingRepos = (Map)env.getAttribute(this.getExistingReposParam(), Map.class);
        ResultSet epr = (ResultSet)env.getAttribute(this.getEprParam(), ResultSet.class);
        SAXReader reader = new SAXReader();
        int countUpdated = 0;
        int countInserted = 0;
        int countProfileErrors = 0;
        log.info((Object)"Adding/updating repository profiles...");
        ISRegistryService registry = (ISRegistryService)this.serviceLocator.getService(ISRegistryService.class);
        for (String profile : this.resultSetClient.iter(epr, String.class)) {
            try {
                String profId;
                Document doc = reader.read((Reader)new StringReader(profile));
                String dsId = doc.valueOf("//EXTRA_FIELDS/FIELD[./key='OpenAireDataSourceId']/value");
                log.debug((Object)("Registering/updating profile:\n " + profile + "\n"));
                if (existingRepos.containsKey(dsId)) {
                    profId = (String)existingRepos.get(dsId);
                    doc.selectSingleNode("//RESOURCE_IDENTIFIER/@value").setText(profId);
                    registry.updateProfile(profId, doc.asXML(), REPOSITORY_SERVICE_RESOURCE_TYPE);
                    log.debug((Object)("Profile " + profId + " UPDATED for ds " + dsId));
                    ++countUpdated;
                    continue;
                }
                profId = registry.registerProfile(doc.asXML());
                log.debug((Object)("Valid Profile " + profId + " REGISTERED for ds " + dsId));
                ++countInserted;
            }
            catch (Exception e) {
                log.error((Object)("INVALID PROFILE: " + profile), (Throwable)e);
                ++countProfileErrors;
            }
        }
        log.info((Object)("   - updated_profiles: " + countUpdated));
        log.info((Object)("   - inserted_profiles: " + countInserted));
        log.info((Object)("   - profiles_with_errors: " + countProfileErrors));
        env.setAttribute("mainlog:updated_profiles", (Object)countUpdated);
        env.setAttribute("mainlog:inserted_profiles", (Object)countInserted);
        env.setAttribute("mainlog:profiles_with_errors", (Object)countProfileErrors);
        return Arc.DEFAULT_ARC;
    }

    public String getEprParam() {
        return this.eprParam;
    }

    public void setEprParam(String eprParam) {
        this.eprParam = eprParam;
    }

    public String getExistingReposParam() {
        return this.existingReposParam;
    }

    public void setExistingReposParam(String existingReposParam) {
        this.existingReposParam = existingReposParam;
    }
}

