/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.msro.workflows.nodes.datacite;

import eu.dnetlib.data.collector.plugins.datasets.DatasetsByJournalIterator;
import eu.dnetlib.data.collector.plugins.datasets.PangaeaJournalInfo;
import eu.dnetlib.enabling.resultset.client.ResultSetClient;
import eu.dnetlib.enabling.resultset.factory.ResultSetFactory;
import eu.dnetlib.msro.workflows.graph.Arc;
import eu.dnetlib.msro.workflows.nodes.SimpleJobNode;
import eu.dnetlib.msro.workflows.nodes.datacite.IteratorOnQueue;
import eu.dnetlib.msro.workflows.procs.Env;
import eu.dnetlib.rmi.common.ResultSet;
import java.io.Reader;
import java.io.StringReader;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.io.SAXReader;
import org.springframework.beans.factory.annotation.Autowired;

public class CollectDatasetsByJournalJobNode
extends SimpleJobNode {
    private static final Log log = LogFactory.getLog(CollectDatasetsByJournalJobNode.class);
    public static PangaeaJournalInfo END_QUEUE = new PangaeaJournalInfo();
    private String datasourceId;
    private String outputEprParam;
    private String inputEprParam;
    @Autowired
    private ResultSetClient resultSetClient;
    @Autowired
    private ResultSetFactory resultSetFactory;
    private final Executor executor = Executors.newSingleThreadExecutor();

    protected String execute(Env env) throws Exception {
        ResultSet inputEpr = (ResultSet)env.getAttribute(this.inputEprParam, ResultSet.class);
        Iterable input = this.resultSetClient.iter(inputEpr, String.class);
        ArrayBlockingQueue publicationsQueue = new ArrayBlockingQueue(50);
        this.executor.execute(() -> {
            SAXReader reader = new SAXReader();
            for (String inputString : input) {
                try {
                    Document doc = reader.read((Reader)new StringReader(inputString));
                    String jId = doc.valueOf("//FIELD[@name='id']");
                    String dsId = doc.valueOf("//FIELD[@name='datasource']");
                    String dsName = doc.valueOf("//FIELD[@name='name']");
                    String jISSN = doc.valueOf("//FIELD[@name='issn']");
                    PangaeaJournalInfo info = new PangaeaJournalInfo();
                    info.setDatasourceId(dsId);
                    info.setJournalId(jId);
                    info.setJournalName(dsName);
                    info.setJournalISSN(jISSN);
                    publicationsQueue.put(info);
                }
                catch (Exception e) {
                    log.error((Object)e);
                }
            }
            try {
                publicationsQueue.put(END_QUEUE);
            }
            catch (InterruptedException e) {
                log.error((Object)e);
            }
        });
        IteratorOnQueue<PangaeaJournalInfo> itOnQueue = new IteratorOnQueue<PangaeaJournalInfo>(publicationsQueue, END_QUEUE);
        ResultSet eprOutput = this.resultSetFactory.createResultSet(() -> new DatasetsByJournalIterator(itOnQueue));
        env.setAttribute(this.getOutputEprParam(), (Object)eprOutput);
        return Arc.DEFAULT_ARC;
    }

    public String getDatasourceId() {
        return this.datasourceId;
    }

    public void setDatasourceId(String datasourceId) {
        this.datasourceId = datasourceId;
    }

    public String getOutputEprParam() {
        return this.outputEprParam;
    }

    public void setOutputEprParam(String outputEprParam) {
        this.outputEprParam = outputEprParam;
    }

    public String getInputEprParam() {
        return this.inputEprParam;
    }

    public void setInputEprParam(String inputEprParam) {
        this.inputEprParam = inputEprParam;
    }
}

