/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.msro.workflows.nodes.dedup;

import eu.dnetlib.data.proto.DedupSimilarityProtos;
import eu.dnetlib.data.proto.RelTypeProtos;
import eu.dnetlib.data.proto.TypeProtos;
import eu.dnetlib.enabling.tools.blackboard.BlackboardJob;
import eu.dnetlib.msro.workflows.nodes.dedup.DedupConfigurationLoaderJobNode;
import eu.dnetlib.msro.workflows.procs.Token;
import eu.dnetlib.rmi.manager.MSROException;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DedupSimilarityToActionsJobNode
extends DedupConfigurationLoaderJobNode {
    private static final Log log = LogFactory.getLog(DedupSimilarityToActionsJobNode.class);
    private String entityType;

    @Override
    protected void prepareJob(BlackboardJob job, Token token) throws Exception {
        super.prepareJob(job, token);
        String entityType = this.getEntityType();
        if (StringUtils.isBlank((CharSequence)entityType)) {
            throw new MSROException("unable to find wf param: entityType");
        }
        String cf = "_" + RelTypeProtos.SubRelType.dedupSimilarity + "_" + DedupSimilarityProtos.DedupSimilarity.RelName.isSimilarTo;
        switch (TypeProtos.Type.valueOf((String)entityType)) {
            case organization: {
                cf = RelTypeProtos.RelType.organizationOrganization + cf;
                break;
            }
            case person: {
                cf = RelTypeProtos.RelType.personPerson + cf;
                break;
            }
            case result: {
                cf = RelTypeProtos.RelType.resultResult + cf;
                break;
            }
            default: {
                throw new MSROException("invalid parameter entityType: " + entityType);
            }
        }
        log.info((Object)("using similarity CF: " + cf));
        job.getParameters().put("similarityCF", cf);
        token.getEnv().setAttribute("similarityCF", (Object)cf);
    }

    public String getEntityType() {
        return this.entityType;
    }

    public void setEntityType(String entityType) {
        this.entityType = entityType;
    }
}

