/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.msro.workflows.nodes.dedup;

import eu.dnetlib.enabling.locators.UniqueServiceLocator;
import eu.dnetlib.enabling.tools.blackboard.BlackboardJob;
import eu.dnetlib.msro.workflows.graph.Arc;
import eu.dnetlib.msro.workflows.nodes.blackboard.BlackboardWorkflowJobListener;
import eu.dnetlib.msro.workflows.nodes.dedup.DedupConfigurationLoaderJobNode;
import eu.dnetlib.msro.workflows.procs.Env;
import eu.dnetlib.msro.workflows.procs.Token;
import eu.dnetlib.rmi.data.hadoop.HadoopService;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class MinDistSearchHadoopJobNode
extends DedupConfigurationLoaderJobNode {
    private static final Log log = LogFactory.getLog(MinDistSearchHadoopJobNode.class);
    private static final String StatusParam = "MinDistSearchHadoopJobNode.status";
    private static final String DepthParam = "mindist_recursion_depth";
    private static final String UpdateCounterParam = "UpdateCounter.UPDATED";
    private static final String DebugParam = "mindist_DEBUG";
    @Autowired
    private UniqueServiceLocator serviceLocator;
    private boolean debug = false;
    private String outPathParam;
    private String workDir;

    @Override
    protected void prepareJob(BlackboardJob job, Token token) throws Exception {
        String depthString = (String)token.getEnv().getAttribute(DepthParam, String.class);
        log.debug((Object)String.format("found depthParam: '%s'", depthString));
        if (StringUtils.isBlank((CharSequence)depthString)) {
            depthString = "0";
        }
        int depth = Integer.valueOf(depthString);
        String outputPath = this.getPath(this.getWorkDir(), depth);
        HadoopService hadoopService = (HadoopService)this.serviceLocator.getService(HadoopService.class);
        switch (this.getStatusFromEnv(token.getEnv())) {
            case DATALOAD: {
                this.setHadoopJob("dedupSimilarity2GraphJob");
                job.getParameters().put("mapred.output.dir", this.getPath(this.getWorkDir(), depth) + "/out");
                hadoopService.createHdfsDirectory(this.getCluster(), outputPath, true);
                break;
            }
            case DEPTH_N: {
                this.setHadoopJob("dedupMinDistGraphJob");
                String newOutputPath = this.getPath(this.getWorkDir(), depth + 1);
                hadoopService.createHdfsDirectory(this.getCluster(), newOutputPath, true);
                job.getParameters().put(DepthParam, String.valueOf(depth));
                job.getParameters().put(DebugParam, String.valueOf(this.isDebug()));
                job.getParameters().put("mapred.input.dir", outputPath + "/out");
                job.getParameters().put("mapred.output.dir", newOutputPath + "/out");
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("input job parameters: %s", job.getParameters()));
                }
                token.getEnv().setAttribute(DepthParam, (Object)String.valueOf(depth + 1));
                token.getEnv().setAttribute(this.getOutPathParam(), (Object)(newOutputPath + "/out"));
            }
        }
        super.prepareJob(job, token);
    }

    private String getPath(String basePath, int depth) {
        log.info((Object)("got basePath: " + basePath));
        Path fsPath = FileSystems.getDefault().getPath(basePath, "depth_" + depth);
        String path = fsPath.toAbsolutePath().toString();
        log.info((Object)("built outputPath: " + path));
        return path;
    }

    private STATUS getStatusFromEnv(Env env) {
        if (StringUtils.isBlank((CharSequence)((CharSequence)env.getAttribute(StatusParam, String.class)))) {
            return STATUS.DATALOAD;
        }
        STATUS current = STATUS.DATALOAD;
        try {
            current = STATUS.valueOf((String)env.getAttribute(StatusParam, String.class));
            log.debug((Object)("found status: " + current.toString()));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return current;
    }

    protected BlackboardWorkflowJobListener generateBlackboardListener(final Token token) {
        return new BlackboardWorkflowJobListener(token){

            protected void onDone(BlackboardJob job) {
                STATUS status = MinDistSearchHadoopJobNode.this.getStatusFromEnv(token.getEnv());
                log.debug((Object)("complete phase: " + (Object)((Object)status)));
                switch (status) {
                    case DATALOAD: {
                        token.getEnv().setAttribute(MinDistSearchHadoopJobNode.StatusParam, (Object)STATUS.DEPTH_N.toString());
                        token.getEnv().setAttribute(MinDistSearchHadoopJobNode.DepthParam, (Object)"0");
                        token.release("depth_n");
                        break;
                    }
                    case DEPTH_N: {
                        String counter;
                        if (log.isDebugEnabled()) {
                            log.debug((Object)String.format("return job parameters: %s=%s, %s=%s", MinDistSearchHadoopJobNode.DepthParam, job.getParameters().get(MinDistSearchHadoopJobNode.DepthParam), MinDistSearchHadoopJobNode.UpdateCounterParam, job.getParameters().get(MinDistSearchHadoopJobNode.UpdateCounterParam)));
                        }
                        if (StringUtils.isBlank((CharSequence)(counter = (String)job.getParameters().get(MinDistSearchHadoopJobNode.UpdateCounterParam)))) {
                            token.getEnv().removeAttribute(MinDistSearchHadoopJobNode.StatusParam);
                            token.getEnv().removeAttribute(MinDistSearchHadoopJobNode.DepthParam);
                            log.info((Object)String.format("done iteration %s:%s", MinDistSearchHadoopJobNode.UpdateCounterParam, 0));
                            token.release(Arc.DEFAULT_ARC);
                            break;
                        }
                        log.info((Object)String.format("continue with next iteration %s:%s", MinDistSearchHadoopJobNode.UpdateCounterParam, counter));
                        token.release("depth_n");
                    }
                }
            }
        };
    }

    public boolean isDebug() {
        return this.debug;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public String getOutPathParam() {
        return this.outPathParam;
    }

    public void setOutPathParam(String outPathParam) {
        this.outPathParam = outPathParam;
    }

    public String getWorkDir() {
        return this.workDir;
    }

    public void setWorkDir(String workDir) {
        this.workDir = workDir;
    }

    static enum STATUS {
        DATALOAD,
        DEPTH_N;

    }
}

