/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.msro.workflows.nodes.dedup;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.Gson;
import eu.dnetlib.enabling.locators.UniqueServiceLocator;
import eu.dnetlib.miscutils.datetime.DateUtils;
import eu.dnetlib.msro.workflows.graph.Arc;
import eu.dnetlib.msro.workflows.nodes.SimpleJobNode;
import eu.dnetlib.msro.workflows.procs.Env;
import eu.dnetlib.rmi.data.hadoop.actionmanager.RawSet;
import eu.dnetlib.rmi.enabling.ISLookUpDocumentNotFoundException;
import eu.dnetlib.rmi.enabling.ISLookUpService;
import eu.dnetlib.rmi.manager.MSROException;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class PrepareConfiguredActionSetJobNode
extends SimpleJobNode {
    private static final Log log = LogFactory.getLog(PrepareConfiguredActionSetJobNode.class);
    private String dedupConfigSequence;
    private String jobProperty;
    private String actionSetPathParam;
    private String setsParam;
    @Autowired
    private UniqueServiceLocator serviceLocator;

    protected String execute(Env env) throws Exception {
        String actionSetDirectory;
        ArrayList setList = Lists.newArrayList();
        HashMap set = Maps.newHashMap();
        String actionSetId = this.getDedupConfigSequence();
        ISLookUpService isLookUpService = (ISLookUpService)this.serviceLocator.getService(ISLookUpService.class);
        String basePath = isLookUpService.getResourceProfileByQuery("/RESOURCE_PROFILE[./HEADER/RESOURCE_TYPE/@value='ActionManagerServiceResourceType']//SERVICE_PROPERTIES/PROPERTY[@key='basePath']/@value/string()");
        if (StringUtils.isBlank((CharSequence)basePath)) {
            throw new IllegalStateException("missing basePath in ActionManagerService");
        }
        try {
            actionSetDirectory = isLookUpService.getResourceProfileByQuery("/RESOURCE_PROFILE[./HEADER/RESOURCE_TYPE/@value='ActionManagerSetDSResourceType' and .//SET/@id = '" + actionSetId + "']//SET/@ directory/string()");
        }
        catch (ISLookUpDocumentNotFoundException e) {
            throw new MSROException("missing directory in ActionSet profile: " + actionSetId);
        }
        String rawSetId = RawSet.newInstance().getId();
        set.put("rawset", rawSetId);
        set.put("creationDate", DateUtils.now_ISO8601());
        set.put("set", actionSetId);
        set.put("enabled", "true");
        set.put("jobProperty", this.getJobProperty());
        env.setAttribute((String)set.get("jobProperty"), set.get("rawset"));
        String path = basePath + "/" + actionSetDirectory + "/" + rawSetId;
        log.info((Object)("using action set path: " + path));
        env.setAttribute(this.getActionSetPathParam(), (Object)path);
        setList.add(set);
        String sets = new Gson().toJson((Object)setList);
        log.debug((Object)("built set: " + sets));
        env.setAttribute(this.getSetsParam(), (Object)sets);
        return Arc.DEFAULT_ARC;
    }

    public String getJobProperty() {
        return this.jobProperty;
    }

    public void setJobProperty(String jobProperty) {
        this.jobProperty = jobProperty;
    }

    public String getActionSetPathParam() {
        return this.actionSetPathParam;
    }

    public void setActionSetPathParam(String actionSetPathParam) {
        this.actionSetPathParam = actionSetPathParam;
    }

    public String getDedupConfigSequence() {
        return this.dedupConfigSequence;
    }

    public void setDedupConfigSequence(String dedupConfigSequence) {
        this.dedupConfigSequence = dedupConfigSequence;
    }

    public String getSetsParam() {
        return this.setsParam;
    }

    public void setSetsParam(String setsParam) {
        this.setsParam = setsParam;
    }
}

