/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.msro.workflows.nodes.dfm;

import eu.dnetlib.enabling.locators.UniqueServiceLocator;
import eu.dnetlib.monitoring.core.sensors.Sensor;
import eu.dnetlib.monitoring.core.sensors.SensorCreationException;
import eu.dnetlib.monitoring.core.sensors.SensorFactory;
import eu.dnetlib.monitoring.core.sensors.collection.SensorWrapper;
import eu.dnetlib.monitoring.core.sensors.collection.index.solr.SolrSensor;
import eu.dnetlib.monitoring.core.sensors.collection.kv.redis.RedisSensor;
import eu.dnetlib.msro.workflows.graph.Arc;
import eu.dnetlib.msro.workflows.nodes.SimpleJobNode;
import eu.dnetlib.msro.workflows.procs.Env;
import eu.dnetlib.rmi.enabling.ISLookUpException;
import java.io.IOException;
import javax.annotation.Resource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TriggerPrepublicMonitoringScenarioJobNode
extends SimpleJobNode {
    private final Log log = LogFactory.getLog(TriggerPrepublicMonitoringScenarioJobNode.class);
    private static final String SOLR_COLLECTION_POSTFIX = "-index-openaire";
    private String mdFormat;
    @Resource
    private UniqueServiceLocator serviceLocator;
    private SolrSensor solrSensor;
    private RedisSensor redisSensor;
    private SensorWrapper wrapper;

    protected String execute(Env env) throws IOException, InstantiationException, IllegalAccessException, InterruptedException, ISLookUpException, SensorCreationException {
        this.log.info((Object)"Execution of TriggerPrepublicMonitoringScenarioJobNode");
        String actualCollection = this.mdFormat + SOLR_COLLECTION_POSTFIX;
        this.log.info((Object)("At this round, the Pre-public monitoring scenario will check against " + actualCollection + " SOLR collection"));
        this.solrSensor = (SolrSensor)SensorFactory.createSensorWithConfiguration(SolrSensor.class, (String)"prepublic", (String)"solr");
        this.solrSensor.getConfiguration().setParam("collection", (Object)actualCollection);
        this.solrSensor.reinitialize();
        this.redisSensor = (RedisSensor)SensorFactory.createSensorWithConfiguration(RedisSensor.class, (String)"prepublic", (String)"redis");
        this.wrapper = (SensorWrapper)SensorFactory.createSensor(SensorWrapper.class);
        this.wrapper.registerSensor((Sensor)this.solrSensor);
        this.wrapper.registerSensor((Sensor)this.redisSensor);
        this.log.info((Object)"Measuring prepublic scenario");
        this.wrapper.measure();
        this.log.info((Object)"DONE!");
        return Arc.DEFAULT_ARC;
    }

    public String getMdFormat() {
        return this.mdFormat;
    }

    public void setMdFormat(String mdFormat) {
        this.mdFormat = mdFormat;
    }
}

