/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.msro.workflows.nodes.hadoop;

import eu.dnetlib.msro.workflows.graph.Arc;
import eu.dnetlib.msro.workflows.nodes.hadoop.AbstractHBaseAdminJobNode;
import eu.dnetlib.msro.workflows.procs.Env;
import eu.dnetlib.rmi.data.hadoop.HadoopService;
import eu.dnetlib.rmi.manager.MSROException;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CreateHBaseTableJobNode
extends AbstractHBaseAdminJobNode {
    private static final Log log = LogFactory.getLog(CreateHBaseTableJobNode.class);
    private boolean reuseRegionInfo = false;

    protected String execute(Env env) throws Exception {
        Set<String> columns = this.getColumns(env);
        log.info((Object)("Ensuring table " + this.getTableName() + " on cluster: '" + this.getCluster() + "' - columns: " + columns));
        HadoopService hadoopService = (HadoopService)this.getServiceLocator().getService(HadoopService.class);
        log.info((Object)String.format("reuse region info: %s", this.isReuseRegionInfo()));
        if (this.isReuseRegionInfo()) {
            String jsonConf = (String)env.getAttribute(this.getTableConfigurationParamName(), String.class);
            log.debug((Object)String.format("region info: %s", jsonConf));
            if (StringUtils.isBlank((CharSequence)jsonConf)) {
                throw new MSROException("cannot find HBase table configuration in workflow env");
            }
            hadoopService.createConfiguredHbaseTable(this.getCluster(), this.getTableName(), jsonConf);
        } else {
            hadoopService.createHbaseTable(this.getCluster(), this.getTableName(), columns);
        }
        return Arc.DEFAULT_ARC;
    }

    public boolean isReuseRegionInfo() {
        return this.reuseRegionInfo;
    }

    public void setReuseRegionInfo(boolean reuseRegionInfo) {
        this.reuseRegionInfo = reuseRegionInfo;
    }
}

