/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.msro.workflows.nodes.hostedby;

import com.google.common.collect.Maps;
import eu.dnetlib.enabling.locators.UniqueServiceLocator;
import eu.dnetlib.enabling.resultset.client.ResultSetClient;
import eu.dnetlib.enabling.resultset.factory.ResultSetFactory;
import eu.dnetlib.msro.workflows.graph.Arc;
import eu.dnetlib.msro.workflows.nodes.SimpleJobNode;
import eu.dnetlib.msro.workflows.nodes.hostedby.HostedByCounters;
import eu.dnetlib.msro.workflows.nodes.hostedby.HostedByEntry;
import eu.dnetlib.msro.workflows.nodes.hostedby.PatchHostedBy;
import eu.dnetlib.msro.workflows.procs.Env;
import eu.dnetlib.rmi.common.ResultSet;
import eu.dnetlib.rmi.data.DatabaseException;
import eu.dnetlib.rmi.data.DatabaseService;
import java.io.Reader;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.io.SAXReader;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;

public class PatchHostedByJobNode
extends SimpleJobNode {
    private String inputEprParam;
    private String outputEprParam;
    @Value(value="${dnet.openaire.db.name}")
    private String dbName;
    private String countersParam;
    private String hostedbyMapTable;
    private String xpathEntry;
    private String overrideDataSourceId;
    @Autowired
    private UniqueServiceLocator serviceLocator;
    @Autowired
    private ResultSetFactory resultSetFactory;
    @Autowired
    private ResultSetClient resultSetClient;
    private static final Log log = LogFactory.getLog(PatchHostedByJobNode.class);

    protected String execute(Env env) throws Exception {
        ResultSet inputEpr = (ResultSet)env.getAttribute(this.inputEprParam, ResultSet.class);
        HostedByCounters counters = new HostedByCounters();
        String datasourceId = StringUtils.isEmpty((CharSequence)this.overrideDataSourceId) ? (String)env.getAttribute("parentDatasourceId", String.class) : this.getOverrideDataSourceId();
        PatchHostedBy mapper = new PatchHostedBy(this.loadHostedByMap(datasourceId), this.getXpathEntry(), counters);
        ResultSet epr = this.resultSetFactory.map(inputEpr, String.class, (Function)mapper);
        env.setAttribute(this.outputEprParam, (Object)epr);
        env.setAttribute(this.countersParam, (Object)counters);
        return Arc.DEFAULT_ARC;
    }

    private Map<String, HostedByEntry> loadHostedByMap(String datasourceId) throws DocumentException, DatabaseException {
        HashMap map = Maps.newHashMap();
        String sql = "SELECT d.id, d.officialname, p.entry from %s p JOIN datasources d ON (p.datasourceid = d.id) WHERE p.oa_source_id= '%s'";
        ResultSet epr = ((DatabaseService)this.serviceLocator.getService(DatabaseService.class)).searchSQL(this.getDbName(), String.format("SELECT d.id, d.officialname, p.entry from %s p JOIN datasources d ON (p.datasourceid = d.id) WHERE p.oa_source_id= '%s'", this.getHostedbyMapTable(), datasourceId));
        SAXReader reader = new SAXReader();
        for (String s : this.resultSetClient.iter(epr, String.class)) {
            Document doc = reader.read((Reader)new StringReader(s));
            String entry = doc.valueOf("//FIELD[@name='entry']");
            String dsId = doc.valueOf("//FIELD[@name='id']");
            String dsName = doc.valueOf("//FIELD[@name='officialname']");
            map.put(entry, new HostedByEntry(dsId, dsName));
        }
        log.info((Object)String.format("built hostedByMap from dsId '%s', size: '%s'", datasourceId, map.size()));
        return map;
    }

    public String getInputEprParam() {
        return this.inputEprParam;
    }

    public void setInputEprParam(String inputEprParam) {
        this.inputEprParam = inputEprParam;
    }

    public String getOutputEprParam() {
        return this.outputEprParam;
    }

    public void setOutputEprParam(String outputEprParam) {
        this.outputEprParam = outputEprParam;
    }

    public String getDbName() {
        return this.dbName;
    }

    public void setDbName(String dbName) {
        this.dbName = dbName;
    }

    public String getCountersParam() {
        return this.countersParam;
    }

    public void setCountersParam(String countersParam) {
        this.countersParam = countersParam;
    }

    public String getHostedbyMapTable() {
        return this.hostedbyMapTable;
    }

    public void setHostedbyMapTable(String hostedbyMapTable) {
        this.hostedbyMapTable = hostedbyMapTable;
    }

    public String getXpathEntry() {
        return this.xpathEntry;
    }

    public void setXpathEntry(String xpathEntry) {
        this.xpathEntry = xpathEntry;
    }

    public String getOverrideDataSourceId() {
        return this.overrideDataSourceId;
    }

    public void setOverrideDataSourceId(String overrideDataSourceId) {
        this.overrideDataSourceId = overrideDataSourceId;
    }
}

