/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.msro.workflows.nodes.index;

import eu.dnetlib.enabling.tools.blackboard.BlackboardJob;
import eu.dnetlib.msro.workflows.nodes.BlackboardJobNode;
import eu.dnetlib.msro.workflows.procs.Env;
import eu.dnetlib.msro.workflows.procs.Token;
import eu.dnetlib.rmi.enabling.ISLookUpException;
import eu.dnetlib.rmi.enabling.ISLookUpService;
import eu.dnetlib.rmi.manager.MSROException;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class SwitchIndexJobNode
extends BlackboardJobNode {
    private static final String BB_ACTION_SWITCH_INDEX = "UpdateIndex";
    private String inputIndexIdParam;
    private String outputIndexIdParam;
    private String xqueryForServiceIdParam;

    protected String obtainServiceId(Env env) {
        String xquery = (String)env.getAttribute(this.getXqueryForServiceIdParam(), String.class);
        try {
            List searchServiceIds = ((ISLookUpService)this.getServiceLocator().getService(ISLookUpService.class)).quickSearchProfile(xquery);
            if (searchServiceIds.size() > 1) {
                throw new RuntimeException("Too many SearchService ids found using query: " + xquery);
            }
            if (searchServiceIds.size() < 1) {
                throw new RuntimeException("SearchService id not found using query: " + xquery);
            }
            return (String)searchServiceIds.get(0);
        }
        catch (ISLookUpException e) {
            throw new RuntimeException(e);
        }
    }

    protected void prepareJob(BlackboardJob job, Token token) throws Exception {
        job.setAction(BB_ACTION_SWITCH_INDEX);
        String indexId = (String)token.getEnv().getAttribute(this.getInputIndexIdParam(), String.class);
        this.checkParam(this.getInputIndexIdParam(), "output indexId param is missing");
        this.checkParam(indexId, "indexId is required to perform switch");
        job.getParameters().put(this.getOutputIndexIdParam(), indexId);
    }

    private void checkParam(String param, String msg) throws MSROException {
        if (StringUtils.isBlank((CharSequence)param)) {
            throw new MSROException(msg);
        }
    }

    public String getInputIndexIdParam() {
        return this.inputIndexIdParam;
    }

    public void setInputIndexIdParam(String inputIndexIdParam) {
        this.inputIndexIdParam = inputIndexIdParam;
    }

    public String getOutputIndexIdParam() {
        return this.outputIndexIdParam;
    }

    public void setOutputIndexIdParam(String outputIndexIdParam) {
        this.outputIndexIdParam = outputIndexIdParam;
    }

    public String getXqueryForServiceIdParam() {
        return this.xqueryForServiceIdParam;
    }

    public void setXqueryForServiceIdParam(String xqueryForServiceIdParam) {
        this.xqueryForServiceIdParam = xqueryForServiceIdParam;
    }
}

