package eu.dnetlib.msro.workflows.nodes;

import java.util.List;
import java.util.Map;

import javax.annotation.Resource;

import com.google.common.collect.Maps;

import eu.dnetlib.enabling.locators.UniqueServiceLocator;
import eu.dnetlib.msro.workflows.graph.Arc;
import eu.dnetlib.msro.workflows.nodes.SimpleJobNode;
import eu.dnetlib.msro.workflows.procs.Env;
import eu.dnetlib.rmi.enabling.ISLookUpService;

public class FindExistingRepositoriesJobNode extends SimpleJobNode {

	@Resource
	private UniqueServiceLocator serviceLocator;

	private String existingReposParam = "existingRepos";

	@Override
	protected String execute(final Env env) throws Exception {
		final String xquery =
				"for $x in collection('/db/DRIVER/RepositoryServiceResources/RepositoryServiceResourceType') " +
						"return concat (" +
						"$x//RESOURCE_IDENTIFIER/@value, " +
						"'@@@', " +
						"$x//EXTRA_FIELDS/FIELD[./key='OpenAireDataSourceId']/value)";
		final List<String> list = this.serviceLocator.getService(ISLookUpService.class).quickSearchProfile(xquery);

		final Map<String, String> map = Maps.newHashMap();
		for (final String s : list) {
			final String[] arr = s.split("@@@");
			if (arr.length == 2) {
				map.put(arr[1], arr[0]);
			}
		}
		env.setAttribute(getExistingReposParam(), map);

		return Arc.DEFAULT_ARC;
	}

	public String getExistingReposParam() {
		return this.existingReposParam;
	}

	public void setExistingReposParam(final String existingReposParam) {
		this.existingReposParam = existingReposParam;
	}

}
