package eu.dnetlib.msro.workflows.nodes.actionmanager;

import javax.annotation.Resource;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Required;

import eu.dnetlib.enabling.locators.UniqueServiceLocator;
import eu.dnetlib.msro.workflows.graph.Arc;
import eu.dnetlib.msro.workflows.nodes.SimpleJobNode;
import eu.dnetlib.msro.workflows.procs.Env;
import eu.dnetlib.rmi.enabling.ISRegistryService;

public class CleanActionSetsProfileJobNode extends SimpleJobNode {

	/**
	 * logger.
	 */
	private static final Log log = LogFactory.getLog(CleanActionSetsProfileJobNode.class);

	@Resource
	private UniqueServiceLocator serviceLocator;

	private String xupdate;

	@Override
	protected String execute(final Env env) throws Exception {
		log.info("updating Action Sets profiles: " + getXupdate());
		this.serviceLocator.getService(ISRegistryService.class).executeXUpdate(getXupdate());
		return Arc.DEFAULT_ARC;
	}

	public String getXupdate() {
		return this.xupdate;
	}

	@Required
	public void setXupdate(final String xupdate) {
		this.xupdate = xupdate;
	}

}
