package eu.dnetlib.msro.workflows.nodes.actionmanager;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import eu.dnetlib.enabling.tools.blackboard.BlackboardJob;
import eu.dnetlib.msro.workflows.nodes.BlackboardJobNode;
import eu.dnetlib.msro.workflows.procs.Env;
import eu.dnetlib.msro.workflows.procs.Token;
import eu.dnetlib.rmi.data.hadoop.actionmanager.ActionManagerService;

/**
 * Created by claudio on 15/04/16.
 */
public class GarbageSetsHDFSJobNode extends BlackboardJobNode {

	/**
	 * logger.
	 */
	private static final Log log = LogFactory.getLog(GarbageSetsJobNode.class);

	@Override
	protected String obtainServiceId(final Env env) {
		return getServiceLocator().getServiceId(ActionManagerService.class);
	}

	@Override
	protected void prepareJob(final BlackboardJob job, final Token token) throws Exception {
		log.info("preparing garbage collection for Action sets Job");
		job.setAction("GARBAGE_HDFS");
	}

}
