package eu.dnetlib.msro.workflows.nodes.actionmanager;

import org.apache.commons.lang3.StringUtils;

import eu.dnetlib.enabling.tools.blackboard.BlackboardJob;
import eu.dnetlib.msro.workflows.nodes.BlackboardJobNode;
import eu.dnetlib.msro.workflows.procs.Env;
import eu.dnetlib.msro.workflows.procs.Token;
import eu.dnetlib.rmi.data.hadoop.actionmanager.ActionManagerService;

public class PromoteActionsJobNode extends BlackboardJobNode {

	public static final String ALL_SETS = "ALL SETS";

	private String set;

	@Override
	protected String obtainServiceId(final Env env) {
		return getServiceLocator().getServiceId(ActionManagerService.class);
	}

	@Override
	protected void prepareJob(final BlackboardJob job, final Token token) throws Exception {
		job.setAction("PROMOTE");
		if (!StringUtils.isBlank(getSet()) && !getSet().equals(ALL_SETS)) {
			job.getParameters().put("set", getSet());
			token.getEnv().setAttribute("set", getSet());
		}
	}

	public String getSet() {
		return this.set;
	}

	public void setSet(final String set) {
		this.set = set;
	}

}
