package eu.dnetlib.msro.workflows.nodes.contexts;

import org.springframework.beans.factory.annotation.Autowired;

import eu.dnetlib.enabling.resultset.client.ResultSetClient;
import eu.dnetlib.msro.workflows.graph.Arc;
import eu.dnetlib.msro.workflows.nodes.SimpleJobNode;
import eu.dnetlib.msro.workflows.procs.Env;
import eu.dnetlib.msro.workflows.procs.Token;
import eu.dnetlib.msro.workflows.util.ResultsetProgressProvider;
import eu.dnetlib.rmi.common.ResultSet;

public class ProcessContextsJobNode extends SimpleJobNode {

	private String eprParam;
	private String contextObj;
	private String contextId;
	private String contextLabel;
	private String contextType;

	@Autowired
	private ResultSetClient resultSetClient;

	@Override
	protected void beforeStart(final Token token) {
		final ResultSet<?> epr = token.getEnv().getAttribute(getEprParam(), ResultSet.class);
		token.setProgressProvider(new ResultsetProgressProvider(epr, this.resultSetClient));
	}

	@Override
	protected String execute(final Env env) throws Exception {

		final ResultSet<?> epr = env.getAttribute(this.eprParam, ResultSet.class);

		final Iterable<String> iter = this.resultSetClient.iter(epr, String.class);

		final ContextDesc context = ContextUtils.getContext(iter, getContextId(), getContextLabel(), getContextType());

		env.setAttribute(this.contextObj, context);

		return Arc.DEFAULT_ARC;
	}

	public String getEprParam() {
		return this.eprParam;
	}

	public void setEprParam(final String eprParam) {
		this.eprParam = eprParam;
	}

	public String getContextObj() {
		return this.contextObj;
	}

	public void setContextObj(final String contextObj) {
		this.contextObj = contextObj;
	}

	public String getContextId() {
		return this.contextId;
	}

	public void setContextId(final String contextId) {
		this.contextId = contextId;
	}

	public String getContextLabel() {
		return this.contextLabel;
	}

	public void setContextLabel(final String contextLabel) {
		this.contextLabel = contextLabel;
	}

	public String getContextType() {
		return this.contextType;
	}

	public void setContextType(final String contextType) {
		this.contextType = contextType;
	}
}
