package eu.dnetlib.msro.workflows.nodes.dedup;

import eu.dnetlib.data.proto.DedupSimilarityProtos.DedupSimilarity;
import eu.dnetlib.data.proto.RelTypeProtos.RelType;
import eu.dnetlib.data.proto.RelTypeProtos.SubRelType;
import eu.dnetlib.data.proto.TypeProtos.Type;
import eu.dnetlib.enabling.tools.blackboard.BlackboardJob;
import eu.dnetlib.msro.workflows.procs.Token;
import eu.dnetlib.rmi.manager.MSROException;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DedupSimilarityToActionsJobNode extends DedupConfigurationLoaderJobNode {

	private static final Log log = LogFactory.getLog(DedupSimilarityToActionsJobNode.class); // NOPMD by marko on 11/24/08 5:02 PM

	private String entityType;

	@Override
	protected void prepareJob(final BlackboardJob job, final Token token) throws Exception {
		super.prepareJob(job, token);

		final String entityType = getEntityType();
		if (StringUtils.isBlank(entityType))
			throw new MSROException("unable to find wf param: entityType");

		String cf = "_" + SubRelType.dedupSimilarity + "_" + DedupSimilarity.RelName.isSimilarTo;
		switch (Type.valueOf(entityType)) {

		case organization:
			cf = RelType.organizationOrganization + cf;
			break;
		case person:
			cf = RelType.personPerson + cf;
			break;
		case result:
			cf = RelType.resultResult + cf;
			break;
		default:
			throw new MSROException("invalid parameter entityType: " + entityType);
		}

		log.info("using similarity CF: " + cf);
		job.getParameters().put("similarityCF", cf);
		token.getEnv().setAttribute("similarityCF", cf);
	}

	public String getEntityType() {
		return entityType;
	}

	public void setEntityType(final String entityType) {
		this.entityType = entityType;
	}
}
