package eu.dnetlib.msro.workflows.nodes.hadoop;

import java.util.Set;

import eu.dnetlib.msro.workflows.graph.Arc;
import eu.dnetlib.msro.workflows.procs.Env;
import eu.dnetlib.openaire.hadoop.utils.HBaseTableUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DefineHBaseOpenaireSchemaJobNode extends AbstractHBaseAdminJobNode {

	private static final Log log = LogFactory.getLog(DefineHBaseOpenaireSchemaJobNode.class); // NOPMD by marko on 11/24/08 5:02 PM

	@Override
	protected String execute(final Env env) throws Exception {

		final Set<String> columns = HBaseTableUtils.listAllColumns();
		log.info("table definition: " + columns);
		env.setAttribute(getTableColumnsParamName(), asCSV(columns));

		return Arc.DEFAULT_ARC;
	}

}
