package eu.dnetlib.msro.workflows.nodes.hadoop;

import javax.annotation.Resource;

import eu.dnetlib.msro.workflows.graph.Arc;
import eu.dnetlib.msro.workflows.procs.Env;
import eu.dnetlib.rmi.common.ResultSet;
import eu.dnetlib.rmi.data.MDStoreService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import eu.dnetlib.enabling.locators.UniqueServiceLocator;
import eu.dnetlib.msro.workflows.nodes.SimpleJobNode;

/**
 * This jobNode reads all the metadata records from all the mongodb collections and generates an hdfs sequence file.
 *
 * @author claudio
 *
 */
public class MDStoreBatchExporterJobNode extends SimpleJobNode {

	private static final Log log = LogFactory.getLog(MDStoreBatchExporterJobNode.class); // NOPMD by marko on 11/24/08 5:02 PM

	private String format;

	private String layout;

	private String interpretation;

	private String outputEprParam;

	@Resource
	private UniqueServiceLocator serviceLocator;

	@Override
	public String execute(final Env env) throws Exception {
		log.info("bulk reading MDStores: " + getFormat() + "-" + getLayout() + "-" + getInterpretation());
		final ResultSet<String> rs =
				getServiceLocator().getService(MDStoreService.class).bulkDeliverMDRecords(getFormat(), getLayout(), getInterpretation());

		env.setAttribute(getOutputEprParam(), rs);

		return Arc.DEFAULT_ARC;
	}

	public String getFormat() {
		return format;
	}

	public void setFormat(final String format) {
		this.format = format;
	}

	public String getLayout() {
		return layout;
	}

	public void setLayout(final String layout) {
		this.layout = layout;
	}

	public String getInterpretation() {
		return interpretation;
	}

	public void setInterpretation(final String interpretation) {
		this.interpretation = interpretation;
	}

	public String getOutputEprParam() {
		return outputEprParam;
	}

	public void setOutputEprParam(final String outputEprParam) {
		this.outputEprParam = outputEprParam;
	}

	public UniqueServiceLocator getServiceLocator() {
		return serviceLocator;
	}

}
