package eu.dnetlib.msro.workflows.nodes.hadoop;

import java.util.Map;

import eu.dnetlib.rmi.data.hadoop.ClusterName;
import eu.dnetlib.rmi.data.hadoop.HadoopService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import eu.dnetlib.enabling.locators.UniqueServiceLocator;
import eu.dnetlib.msro.workflows.graph.Arc;
import eu.dnetlib.msro.workflows.nodes.SimpleJobNode;
import eu.dnetlib.msro.workflows.procs.Env;
import eu.dnetlib.rmi.enabling.ISLookUpDocumentNotFoundException;
import eu.dnetlib.rmi.enabling.ISLookUpException;
import eu.dnetlib.rmi.enabling.ISLookUpService;
import org.springframework.beans.factory.annotation.Autowired;

public class PrepareStatsParamJobNode extends SimpleJobNode {

	/**
	 * logger.
	 */
	private static final Log log = LogFactory.getLog(PrepareStatsParamJobNode.class); // NOPMD by marko on 11/24/08 5:02 PM

	private static final String xqueryIsLookupEndpoint =
			"//RESOURCE_PROFILE[.//RESOURCE_TYPE/@value='IS_LookUpServiceResourceType']//PROTOCOL[./@name='SOAP']/@address/string()";

	@Autowired
	private UniqueServiceLocator serviceLocator;

	@Override
	protected String execute(final Env env) throws Exception {

		log.info("prepare stats update job");

		final Map<String, String> conf = serviceLocator.getService(HadoopService.class).getClusterConfiguration(ClusterName.DM.toString());
		final String nameNode = conf.get("fs.defaultFS");

		env.setAttribute("nameNode", nameNode);
		env.setAttribute("jobTracker", conf.get("mapred.job.tracker"));

		env.setAttribute("isLookupEndpoint", getIsLookupEndpoint());

		return Arc.DEFAULT_ARC;
	}

	private String getIsLookupEndpoint() throws ISLookUpException {
		return this.serviceLocator.getService(ISLookUpService.class).getResourceProfileByQuery(xqueryIsLookupEndpoint);
	}

}
